C Example of a gauge field theory.
  Lagrangian.

BLOCK VERT{}
S N,N_,M,m
F VE4,VE3,PROP
I al=N, be=N, ga=N, de=N, la=N, ka=N
I l1=3,l2=3,l2=3,l3=3,l4=3,l5=3,l6=3,l7=3,l8=3,l9=3
V p,k,pp,kp,q,qs,qt,qu

C F=fi triplet, W=vector boson triplet, Z=Higgs, X=FP ghost triplet.

T TAP: F,U,W,Z
T TFE: X
T THI: Z=1:1,U=1:1
Antilist TAP

X DEDE(al,be,ga,de)=2.*D(al,be)*D(ga,de) - D(al,de)*D(be,ga)
					 - D(al,ga)*D(be,de)
G 1
X FF(l1,al,l2,be;p)  = NOM(p,M)*D(l1,l2)
X WW(l1,al,l2,be;p)  = NOM(p,M)*D(al,be)*D(l1,l2)
X X_X(l1,al,l2,be;p) = NOM(p,M)*D(l1,l2)

X WWW(l1,al,k,l2,be,p,l3,ga,q) =
 -i*Epf(l1,l2,l3)*D(al,ga)*(k(be)-q(be))
 -i*Epf(l1,l2,l3)*D(be,ga)*(q(al)-p(al))
 -i*Epf(l1,l2,l3)*D(al,be)*(p(ga)-k(ga))

X FFW(l2,be,p,l3,ga,q,l1,al,k) = 0.5*i*Epf(l1,l2,l3)*p(al)
				-0.5*i*Epf(l1,l2,l3)*q(al)

X WWWW(l1,al,k,l2,be,p,l3,ga,q,l4,de,pp) =
   -D(l4,l2)*D(l1,l3)*DEDE(al,ga,be,de)+D(l4,l1)*D(l3,l2)*DEDE(al,ga,be,de)
   -D(l4,l3)*D(l2,l1)*DEDE(al,be,ga,de)+D(l4,l1)*D(l2,l3)*DEDE(al,be,ga,de)
X FFWW(l3,ga,k,l4,de,p,l1,al,q,l2,be,pp) = - 0.5*D(l1,l2)*D(l3,l4)*D(al,be)
X FFFF(l1,al,k,l2,be,p,l3,ga,q,l4,de,pp) =
	- 0.25*m^2/M^2*D(l1,l2)*D(l3,l4)
	- 0.25*m^2/M^2*D(l1,l3)*D(l2,l4)
	- 0.25*m^2/M^2*D(l1,l4)*D(l2,l3)

X WX_X(l1,al,k,l2,be,p,l3,ga,q) = i*Epf(l1,l2,l3)*p(al)
X FX_X(l1,al,k,l2,be,p,l3,ga,q) = 0.5*M*Epf(l1,l2,l3)

G 2
X ZZ(l1,al,l2,be;p)  = NOM(p,m)

X FWZ(l2,be,p,l1,al,k,l3,ga,q) = 0.5*i*D(l1,l2)*p(al)
				-0.5*i*D(l1,l2)*q(al)
X WWZ(l1,al,k,l2,be,p,l3,ga,q) = - M*D(l1,l2)*D(al,be)
X FFZ(l1,al,k,l2,be,p,l3,ga,q) = - 0.5*m^2/M*D(l1,l2)
X ZZZ(l1,al,k,l2,be,p,l3,ga,q) = - 1.5*m^2/M

X WWZZ(l1,al,k,l2,be,p,l3,ga,q,l4,de,pp) = - 0.5*D(l1,l2)*D(al,be)
X FFZZ(l1,al,k,l2,be,p,l3,ga,q,l4,de,pp) = - 0.25*m^2/M^2*D(l1,l2)
X ZZZZ(l1,al,k,l2,be,p,l3,ga,q,l4,de,pp) = - 0.75*m^2/M^2

X X_XZ(l1,al,k,l2,be,p,l3,ga,q) = - 0.5*M*D(l1,l2)

G 3
C Tadpole counterterm.

X NNZ(l1,al,k,l2,be,p,l3,ga,q) = - M*m^2*Et

C Self-energy counter terms.

X NWW(l1,al,k,l2,be,p,l3,ga,q) = - {2*M^2*Ew + 2*M^2*E1 - 2*pDq*Ew}
 * D(l2,l3)*D(be,ga) - 2*p(be)*q(ga)*D(l2,l3)*Ew
X FFN(l2,be,p,l3,ga,q,l1,al,k) = 2*pDq*Eh*D(l2,l3) - 1/2*m^2*Et*D(l2,l3)
X FNW(l2,be,p,l1,al,k,l3,ga,q) = M*(Ew+Eh+E1)*D(l2,l3)*i*p(ga)
X NZZ(l1,al,k,l2,be,p,l3,ga,q) = m^2*{-2*Eh-1/2*Et+2*E2-2*E1} + 2*pDq*Eh

G 4
C Three point counter terms.

X WWWK = Eg+3*Ew
X FFWK = Eg+Ew+2*Eh
X FWZK = Eg+Ew+2*Eh
X WWZK = Eg+2*Ew+Eh+E1
X FFZK = Eg+3*Eh-2*E2+E1
X ZZZK = Eg+3*Eh-2*E2+E1

C Four-point counter terms.

X WWWWK = 2*Eg+4*Ew
X FFWWK = 2*Eg+2*Ew+2*Eh
X FFFFK = 2*Eg+4*Eh-2*E2
X WWZZK = 2*Eg+2*Ew+2*Eh
X FFZZK = 2*Eg+4*Eh-2*E2
X ZZZZK = 2*Eg+4*Eh-2*E2

G 5
C New Higgs-like particle...
  Mass: as Higgs, i.e. m.
  Coupling: - 1/4* gu * U^2 * { (Z+2M/g)^2 + Fi^2 }
  Choice: gu = g^2 * m^2/4/M^2*gu

Gotoif 2,_Sw0=0
X UU(l1,al,l2,be;p)  = NOM(p,M)
Goto 3
@2
X UU(l1,al,l2,be;p)  = NOM(p,m)
@3

X UUZ(l1,al,k,l2,be,p,l3,ga,q) = - 0.5*m^2/M*gu
X FFUU(l1,al,k,l2,be,p,l3,ga,q,l4,de,pp) = - 0.25*m^2/M^2*D(l1,l2)*gu
X UUZZ(l1,al,k,l2,be,p,l3,ga,q,l4,de,pp) = - 0.25*m^2/M^2*gu

G
ENDBLOCK

BLOCK FOUR{}
C Four point topologies, including reducible graphs and tadpole types.
  Call: 
     VIER("A,a,al,k,"B,b,p,p,"C,c,pp,pp,"D,d,kp,kp)

  The result needs additional contributions, obtained by crossing, as
  shown here:

   + VIER("A,a,al,k,"C,c,ga,pp,"B,b,be,p,"D,d,de,kp)
   + VIER("A,a,al,k,"B,b,be,p,"D,d,de,kp,"C,c,ga,pp)

Id,VIER(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,K4~,d~,de~,kp~)=

     Reduc(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp)

   + Redup(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp)

   + Tadp(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp)

   + DS(K1;J4;-J1;TAP,(
     DS(K2;J1;-J2;TAP,(
     DS(K3;J2;-J3;TAP,(
    A0*VIE(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J1,J2,J3,J4)
     * DC("F,TFE,-1,J1,J2,J3,J4) ))) )))

    + DS(K1;K3;J7;-J5;TAP,(
     DS(K2;J5;-J6;TAP,(DC("F,TFE,-1,J5,J6,J7)*
    A1*VIE1(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J5,J6,J7) )) ))

   + DS(K2;K4;J8;-J9;TAP,(
     DS(K1;JA;-J8;TAP,(DC("F,TFE,-1,J8,J9,JA)*
    A2*VIE2(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J8,J9,JA) )) ))

   + DS(K1;K3;J0;-JB;Sym;J0;-JB;TAP,(DC("F,TFE,-1,J0,JB)*
    A3*VIE3(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,JB,J0) ) )

Id, VIE(K1~,a~,al~,k~,K2~,b~,be~,p~,
	K3~,c~,ga~,pp~,K4~,d~,de~,kp~,J1~,J2~,J3~,J4~)=
   VE3(K1,J4,-J1,*,a,al,k,*,l8,m8,q3,*,l1,m1,-q)*
   VE3(K2,J1,-J2,*,b,be,p,*,l2,m0,q,*,l3,m3,-q1)*
   VE3(K3,J2,-J3,*,c,ga,pp,*,l4,m4,q1,*,l5,m5,-q2)*
   VE3(K4,J3,-J4,*,d,de,kp,*,l6,m6,q2,*,l7,m7,-q3)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q1,*,l4,m4,-q1)*
   PROP(J3,-J3,*,l5,m5,q2,*,l6,m6,-q2)*
   PROP(J4,-J4,*,l7,m7,q3,*,l8,m8,-q3)

Al,VIE1(K1~,a~,al~,k~,K2~,b~,be~,p~,
	K3~,c~,ga~,pp~,K4~,d~,de~,kp~,J1~,J2~,J3~)=
   VE4(K1,K3,J3,-J1,*,a,al,k,*,c,ga,pp,*,l6,m6,q4,*,l1,m1,-q)*
   VE3(K2,J1,-J2,*,b,be,p,*,l2,m0,q,*,l3,m3,-q1)*
   VE3(K4,J2,-J3,*,d,de,kp,*,l4,m4,q1,*,l5,m5,-q4)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q1,*,l4,m4,-q1)*
   PROP(J3,-J3,*,l5,m5,q4,*,l6,m6,-q4)

Al,VIE2(K1~,a~,al~,k~,K2~,b~,be~,p~,
	K3~,c~,ga~,pp~,K4~,d~,de~,kp~,J1~,J2~,J3~)=
   VE4(K2,K4,J1,-J2,*,b,be,p,*,d,de,kp,*,l2,m0,q,*,l3,m3,-q4)*
   VE3(K1,J3,-J1,*,a,al,k,*,l6,m6,q3,*,l1,m1,-q)*
   VE3(K3,J2,-J3,*,c,ga,pp,*,l4,m4,q4,*,l5,m5,-q3)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q4,*,l4,m4,-q4)*
   PROP(J3,-J3,*,l5,m5,q3,*,l6,m6,-q3)

Al,VIE3(K1~,a~,al~,k~,K2~,b~,be~,p~,
	K3~,c~,ga~,pp~,K4~,d~,de~,kp~,J1~,J2~)=
   VE4(K1,K3,J2,-J1,*,a,al,k,*,c,ga,pp,*,l4,m4,q4,*,l1,m1,-q)*
   VE4(K2,K4,J1,-J2,*,b,be,p,*,d,de,kp,*,l2,m0,q,*,l3,m3,-q4)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q4,*,l4,m4,-q4)

Al,Reduc(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,K4~,d~,de~,kp~) =
     DS(K2;K4;J4;TAP,(DS(-J4;J1;-J2;TAP,(
     DS(K1;J3;-J1;TAP,(
     DC("F,TFE,-1,J1,J2,J3)*R1(J4,J4)*
     RED1(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J1,J2,J3,J4) )) )) ))

   + DS(K1;K3;-J8;TAP,(DS(J8;-J5;J7;TAP,(
     DS(K2;J5;-J6;TAP,(
     DC("F,TFE,-1,J5,J6,J7)*R1(J8,J8)*
     RED2(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J5,J6,J7,J8) )) )) ))

   + DS(K1;K3;-J0;JA;Sym;-J0;JA;TAP,(DS(J0;-JA;-JB;TAP,(
     DC("F,TFE,-1,J0,JA)*R1(JB,JB)*
     RED3(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J0,JA,JB) )) ))

   + DS(K1;K3;-JE;TAP,(DS(JE;-JC;JD;Sym;-JC;JD;TAP,(
     DC("F,TFE,-1,JC,JD)*R1(JE,JE)*
     RED4(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,JC,JD,JE) )) ))

   + DS(K1;K3;-JI;TAP,(DS(JI;-JF;JG;Sym;-JF;JG;TAP,(
     DS(JF;-JG;-JH;TAP,(DC("F,TFE,-1,JF,JG)*R5(JI,JI)*
     RED5(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,JF,JG,JH,JI) )) )) ))

   + DS(K1;-JM;K3;TAP,(DS(JM;-JL;-JK;JK;Sym;-JK;JK;TAP,(R5(JM,JM)*
     RED6(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,JK,JL,JM) )) ))

Al,Redup(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,K4~,d~,de~,kp~) =
    DS(K2;K4;J3;TAP,(
      DS(-J2;J1;-J3;K3;Sym;-J2;J1;TAP,(R1(J3,J3)*
    RED3A(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J1,J2,J3) ))
    + DS(J5;-J4;-J3;K1;Sym;J5;-J4;TAP,(R1(J3,J3)*
    RED3B(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J4,J5,J3) ))
    ))

  + DS(K1;K3;J8;TAP,(
      DS(J7;-J6;-J8;K4;Sym;J7;-J6;TAP,(R1(J8,J8)*
    RED4A(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J6,J7,J8) ))
    + DS(JA;-J9;-J8;K2;Sym;JA;-J9;TAP,(R1(J8,J8)*
    RED4B(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J9,JA,J8) ))
    ))

Al,Tadp(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,K4~,d~,de~,kp~) =
    DS(K2;K4;J2;"Z;TAP,(DS("Z;J1;-J1;Sym;J1;-J1;TAP,(
    DC("F,TFE,-1,J1)*
   T1*TAD1(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J1,J2) )) ))

  + DS(K1;K3;-J4;"Z;TAP,(DS("Z;J3;-J3;Sym;J3;-J3;TAP,(
    DC("F,TFE,-1,J3)*
   T2*TAD2(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J3,J4) )) ))

  + DS(K1;-J6;K3;TAP,(DS(J6;-J7;"Z;TAP,(DS("Z;J5;-J5;Sym;J5;-J5;TAP,(
    DC("F,TFE,-1,J5)*
   T3*TAD3(K1,a,al,k,K2,b,be,p,K3,c,ga,pp,K4,d,de,kp,J5,J6,J7) )) )) ))

Id,RED1(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~,J4~) =
   VE3(K1,-J1,J3,*,a,al,k,*,l1,m1,-q,*,l6,m6,q3)*
   VE3(J1,-J4,-J2,*,l2,m0,q,*,l7,m7,-qu,*,l3,m3,-q4)*
   VE3(K2,K4,J4,*,b,be,p,*,d,de,kp,*,l8,m8,qu)*
   VE3(K3,J2,-J3,*,c,ga,pp,*,l4,m4,q4,*,l5,m5,-q3)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q4,*,l4,m4,-q4)*
   PROP(J3,-J3,*,l5,m5,q3,*,l6,m6,-q3)*
   PROP(J4,-J4,*,l7,m7,qu,*,l8,m8,-qu)

Al,RED2(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~,J4~) =
   VE3(K1,-J4,K3,*,a,al,k,*,l7,m7,-qu,*,c,ga,pp)*
   VE3(J4,-J1,J3,*,l8,m8,qu,*,l1,m1,-q,*,l6,m6,q4)*
   VE3(K2,J1,-J2,*,b,be,p,*,l2,m0,q,*,l3,m3,-q1)*
   VE3(K4,J2,-J3,*,d,de,kp,*,l4,m4,q1,*,l5,m5,-q4)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q1,*,l4,m4,-q1)*
   PROP(J3,-J3,*,l5,m5,q4,*,l6,m6,-q4)*
   PROP(J4,-J4,*,l7,m7,qu,*,l8,m8,-qu)

Al,RED3(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~) =
   VE4(K1,-J1,J2,K3,*,a,al,k,*,l1,m1,-q,*,l4,m4,q4,*,c,ga,pp)*
   VE3(J1,-J2,-J3,*,l2,m0,q,*,l3,m3,-q4,*,l5,m5,-qu)*
   VE3(K2,J3,K4,*,b,be,p,*,l6,m6,qu,*,d,de,kp)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q4,*,l4,m4,-q4)*
   PROP(J3,-J3,*,l5,m5,qu,*,l6,m6,-qu)

Al,RED3A(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~) =
   VE3(K2,K4,J3,*,b,be,p,*,d,de,kp,*,l6,m6,qu)*
   VE4(-J2,J1,-J3,K3,*,l3,m3,-q3,*,l2,m0,q,*,l5,m5,-qu,*,c,ga,pp)*
   VE3(K1,-J1,J2,*,a,al,k,*,l1,m1,-q,*,l4,m4,q3)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q3,*,l4,m4,-q3)*
   PROP(J3,-J3,*,l5,m5,qu,*,l6,m6,-qu)

Al,RED3B(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~) =
   VE3(K2,K4,J3,*,b,be,p,*,d,de,kp,*,l6,m6,qu)*
   VE4(J2,-J1,-J3,K1,*,l4,m4,q2,*,l1,m1,-q1,*,l5,m5,-qu,*,a,al,k)*
   VE3(K3,J1,-J2,*,c,ga,pp,*,l2,m0,q1,*,l3,m3,-q2)*
   PROP(J1,-J1,*,l1,m1,q1,*,l2,m0,-q1)*
   PROP(J2,-J2,*,l3,m3,q2,*,l4,m4,-q2)*
   PROP(J3,-J3,*,l5,m5,qu,*,l6,m6,-qu)

Al,RED4(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~) =
   VE3(K1,-J3,K3,*,a,al,k,*,l5,m5,-qu,*,c,ga,pp)*
   VE3(-J1,J2,J3,*,l1,m1,-q,*,l4,m4,q4,*,l6,m6,qu)*
   VE4(K2,J1,-J2,K4,*,b,be,p,*,l2,m0,q,*,l3,m3,-q4,*,d,de,kp)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q4,*,l4,m4,-q4)*
   PROP(J3,-J3,*,l5,m5,qu,*,l6,m6,-qu)

Al,RED4A(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~) =
   VE3(K1,K3,-J3,*,a,al,k,*,c,ga,pp,*,l5,m5,-qu)*
   VE4(J2,-J1,J3,K4,*,l4,m4,q1,*,l1,m1,q,*,l6,m6,qu,*,d,de,kp)*
   VE3(K2,J1,-J2,*,b,be,p,*,l2,m0,q,*,l3,m3,-q1)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q1,*,l4,m4,-q1)*
   PROP(J3,-J3,*,l5,m5,qu,*,l6,m6,-qu)

Al,RED4B(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~) =
   VE3(K1,K3,-J3,*,a,al,k,*,c,ga,pp,*,l5,m5,-qu)*
   VE4(J2,-J1,J3,K2,*,l4,m4,q3,*,l1,m1,q2,*,l6,m6,qu,*,b,be,p)*
   VE3(K4,J1,-J2,*,d,de,kp,*,l2,m0,q2,*,l3,m3,-q3)*
   PROP(J1,-J1,*,l1,m1,q2,*,l2,m0,-q2)*
   PROP(J2,-J2,*,l3,m3,q3,*,l4,m4,-q3)*
   PROP(J3,-J3,*,l5,m5,qu,*,l6,m6,-qu)

Al,RED5(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~,J4~) =
   VE3(K1,-J4,K3,*,a,al,k,*,l7,m7,-qu,*,c,ga,pp)*
   VE3(J4,-J1,J2,*,l8,m8,qu,*,l1,m1,-q,*,l3,m3,q4)*
   VE3(J1,-J2,-J3,*,l2,m0,q,*,l4,m4,-q4,*,l5,m5,-qu)*
   VE3(K2,J3,K4,*,b,be,p,*,l6,m6,qu,*,d,de,kp)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,q4,*,l4,m4,-q4)*
   PROP(J3,-J3,*,l5,m5,qu,*,l6,m6,-qu)*
   PROP(J4,-J4,*,l7,m7,qu,*,l8,m8,-qu)

Al,RED6(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~) =
   VE3(K1,-J3,K3,*,a,al,k,*,l5,m5,-qu,*,c,ga,pp)*
   VE4(J3,-J2,-J1,J1,*,l6,m6,qu,*,l3,m3,-qu,*,l1,m1,-q,*,l2,m0,q)*
   VE3(K2,J2,K4,*,b,be,p,*,l4,m4,qu,*,d,de,kp)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)*
   PROP(J2,-J2,*,l3,m3,qu,*,l4,m4,-qu)*
   PROP(J3,-J3,*,l5,m5,qu,*,l6,m6,-qu)

Id,TAD1(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~) =
   VE4(K2,K4,J2,"Z,*,b,be,p,*,d,de,kp,*,l4,m4,qu,*,l5,m5,q0)*
   VE3(K1,K3,-J2,*,a,al,k,*,c,ga,pp,*,l3,m3,-qu)*
   VE3("Z,J1,-J1,*,l6,m6,-q0,*,l1,m1,-q,*,l2,m0,q)*
   PROP(J2,-J2,*,l3,m3,qu,*,l4,m4,-qu)*
   PROP("Z,"Z,*,l5,m5,q0,*,l6,m6,-q0)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)

Al,TAD2(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~) =
   VE4(K1,K3,-J2,"Z,*,a,al,k,*,c,ga,pp,*,l3,m3,-qu,*,l5,m5,q0)*
   VE3(K2,K4,J2,*,b,be,p,*,d,de,kp,*,l4,m4,qu)*
   VE3("Z,J1,-J1,*,l6,m6,-q0,*,l1,m1,-q,*,l2,m0,q)*
   PROP(J2,-J2,*,l3,m3,qu,*,l4,m4,-qu)*
   PROP("Z,"Z,*,l5,m5,q0,*,l6,m6,-q0)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)

Al,TAD3(K1~,a~,al~,k~,K2~,b~,be~,p~,K3~,c~,ga~,pp~,
    K4~,d~,de~,kp~,J1~,J2~,J3~) =
   VE3(K1,K3,-J2,*,a,al,k,*,c,ga,pp,*,l3,m3,-qu)*
   VE3(J2,-J3,"Z,*,l4,m4,qu,*,l7,m7,-qu,*,l5,m5,-q0)*
   VE3(K2,K4,J3,*,b,be,p,*,d,de,kp,*,l8,m8,qu)*
   VE3("Z,J1,-J1,*,l6,m6,-q0,*,l1,m1,-q,*,l2,m0,q)*
   PROP(J2,-J2,*,l3,m3,qu,*,l4,m4,-qu)*
   PROP(J3,-J3,*,l7,m7,qu,*,l8,m8,-qu)*
   PROP("Z,"Z,*,l5,m5,q0,*,l6,m6,-q0)*
   PROP(J1,-J1,*,l1,m1,q,*,l2,m0,-q)

Id,Anti,TAP
Al,Stats,0
Al,R1("Z,"Z)=R1Z
Al,R5("Z,"Z)=R5Z
Al,R1(J1~,J2~)=1
Al,R5(J1~,J2~)=1

Id,Compo,<X>,VE4,VE3,PROP

Id,VE4(FF~,l1~,al~,k~,l2~,be~,p~,l3~,ga~,pp~,l4~,la~,kp~)=
 FF(l1,al,k,l2,be,p,l3,ga,pp,l4,la,kp)
Al,VE3(FF~,l1~,al~,k~,l2~,be~,q~,l3~,ga~,p~)=
       FF(l1,al,k,l2,be,q,l3,ga,p)
Al,PROP(FF~,l1~,al~,q~,l2~,be~,k~)=FF(l1,al,l2,be,k)
Al,Stats,1
ENDBLOCK

BLOCK ETE1{}
C Counterterms.
Gotoif 2,_Sw0=0

Id,Et=i*Pi^2
  * ( - 3/4 - 3/2*M^2*m^-2 + 9/2*M^2*m^-2*LogM2 - 3/4*M^-2*m^2
  + 3/4*M^-2*m^2*Logm2 + 3/4*LogM2
  - 1/4*gu + 1/4*LogM2*gu )
 
 + i*Pi^2*N_^-1
  * ( 3/2 + 9*M^2*m^-2 + 3/2*M^-2*m^2 + 1/2*gu)
Goto 3

@2
Id,Et=i*Pi^2
  * ( - 3/4 - 3/2*M^2*m^-2 + 9/2*M^2*m^-2*LogM2 - 3/4*M^-2*m^2
  + 3/4*M^-2*m^2*Logm2 + 3/4*LogM2
  - 1/4*M^-2*m^2*gu + 1/4*M^-2*m^2*Logm2*gu )
 
 + i*Pi^2*N_^-1
  * ( 3/2 + 9*M^2*m^-2 + 3/2*M^-2*m^2 + 1/2*M^-2*m^2*gu)

@3
Al,E1= i*Pi^2
  * ( 1/16*M^-2*m^2 + 5/12*Logm2)
 
 - 25/6*i*Pi^2*N_^-1

Goto 2,_Sw0=0
Al,E2 = i*Pi^2*( E2a*m^2/M^2 + E2al*m^2*Logm2/M^2 + E2b + E2bl*Logm2
 + E2c*M^2/m^2 + E2cl*Logm2*M^2/m^2)

 + i*Pi^2*N_^-1
  * ( - 8/3 - 9/2*M^2*m^-2 - 3/2*M^-2*m^2 - 1/8*M^-2*m^2*gu^2)

Goto 3
@2
Id,E2 = i*Pi^2
  * ( 7/16*M^-2*m^2 - 3/4*M^-2*m^2*Logm2 - 3/2 +7/6*Logm2
  - 9/4*M^2/m^2*Logm2 - 9/16*m^2/M^2*[Pi/Sqrt(3)-2]
  - 1/16*M^-2*m^2*Logm2*gu^2 - 1/16*m^2/M^2*[Pi/Sqrt(3)-2]*gu^2)
 
 + i*Pi^2*N_^-1
  * ( - 8/3 - 9/2*M^2*m^-2 - 3/2*M^-2*m^2 - 1/8*M^-2*m^2*gu^2)

@3 
Al,Eh=i*Pi^2*(3/2/N_ + m^2/M^2/16 + 1/8*Logm2)

Al,Ew=i*Pi^2*(19/6/N_ - 1/24*Logm2)

Al,Eg=- 43/6*i*Pi^2/N_

Gotoif 5,_Sw0=0
Id,E2a  = 7/16 - 9/16*[Pi/Sqrt(3)-2] + gu^2/8
Al,E2al = - 3/4 - 1/16*gu^2
Al,E2b  = - 3/2
Al,E2bl = 7/6
Al,E2c  = 0
Al,E2cl = - 9/4
@5

ENDBLOCK

BLOCK ASSIGN{}

A N,N_,M,m,n,n1,n2,n3,n4,Div,Fact,Nom,Nohm

F Fxx,Two,Three,Fq

C q1 = q+p
  q2 = q+p+pp
  q3 = q-k
  q4 = q-k-pp
  q5 = q-k-p
  q6 = q+pp
  q7 = q+kp
  qu = k+pp
  qs = q-k-p
  qt =

  Crossing relations.
  	  p <-> pp				pp <-> kp
  q1 -> q6	pDk  -> ppDk		q1 -> q1	pDk  -> ppDk
  q2 -> q2	  s  -> u	  	q2 -> q4	  s  -> s
  q3 -> q3	ppDk -> pDk		q3 -> q3	ppDk -> kDkp
  q4 -> q5	  u  -> s		q4 -> q2	  u  -> t
  q5 -> q4	pDpp -> pDpp		q5 -> q5	pDpp -> pDkp
  q6 -> q1	  t  -> t		q6 -> q7	  t  -> u
  q7 -> q7				q7 -> q6

V q,q1,q2,q3,q4,q5,q6,q7,qs,qu,qt

I al=N,be=N,la=N,de=N,ga=N,la=N

I a=3,b=3,c=3,d=3

X dede(al,be,ga,de)=D(al,be)*D(ga,de)+D(al,ga)*D(be,de)+D(al,de)*D(be,ga)

C n1: -2 for every factor 1/(q^2+m^2)
  n2: number of factors m
  n3: degree of divergence with respect to integration variable q not
      counting n1 types. Integral is convergent if n3+4 < 0.

X Fdiv(n1,n2,n3)= DT(-n3-4)*DT(n1+n2) + DT(n3+4-1)*DT(n1+n2+4+n3)

C Series expansion for { Nohm/(1-x*Nohm) }^n4
C
X Exp(n1,n2,n3,x,n4) =
   DT(-n3-4)*Nohm^n4*DS(J,0,n1+n2,(DB(n4+J-1,J)*x^J*Nohm^J))
 + DT(n3+4-1)*Nohm^n4*DS(K,0,n1+n2+4+n3,(DB(n4+K-1,K)*x^K*Nohm^K))
ENDBLOCK

BLOCK COUNT{}
Id,Count,Div,q,1,NOM,-2,Nom,-2,Two,-4
Id,m^n~*Fxx(n1~,n2~,n3~,n4~)=m^n*Fxx(n1,n2+n,n3,n4)
Id,[m2-M2]^n~*Fxx(n1~,n2~,n3~,n4~)=[m2-M2]^n*Fxx(n1,n2+2*n,n3,n4)
Id,Div^n~*Fxx(n1~,n2~,n3~,n4~)=Fxx(n1,n2,n3+n,n4)
ENDBLOCK

BLOCK HCOUNT{}
C Count behaviour with respect to m for large m.
  Eliminate if zero in that limit.
IF Nohm^n~=Fxx(-2*n,0,0,n)*Nohm^n
COUNT{}
Id,Fxx(n1~,n2~,n3~,n4~)=Fdiv(n1,n2,n3)
ELSE
Id,Count,0,m,1,[m2-M2],2
ENDIF
ENDBLOCK

BLOCK SHIFT{}

IF Sh1
Al,qDq=qDq-2*qDp+pDp
Al,Dotpr,q(al~)=q(al)-p(al)
ENDIF
IF Sh2
Al,qDq=qDq-2*qDp-2*qDpp+2*pDpp+pDp+ppDpp
Al,Dotpr,q(al~)=q(al)-p(al) - pp(al)
ENDIF
IF Sh3
Al,qDq=qDq+2*qDk+kDk
Al,Dotpr,q(al~)=q(al)+k(al)
ENDIF
IF Sh4
Al,qDq=qDq+2*qDk+2*qDpp+2*kDpp+kDk+ppDpp
Al,Dotpr,q(al~)=q(al)+k(al)+pp(al)
ENDIF
IF Sh5
Al,qDq=qDq+2*qDk+2*qDp+2*kDp+kDk+pDp
Al,Dotpr,q(al~)=q(al)+k(al)+p(al)
ENDIF
IF Sh6
Al,qDq=qDq-2*qDpp+ppDpp
Al,Dotpr,q(al~)=q(al)-pp(al)
ENDIF
IF Sh7
Al,qDq=qDq+2*qDk+2*qDp+2*qDpp+kpDkp
Al,Dotpr,q(al~)=q(al)+k(al)+p(al)+pp(al)
ENDIF

IF NOT Nohm
Id,Sh1=1
Al,Sh2=1
Al,Sh3=1
Al,Sh4=1
Al,Sh5=1
Al,Sh6=1
Al,Sh7=1
ENDIF

Id,pDp=-M^2
Al,kDk=-M^2
Al,ppDpp=-M^2
Al,kpDkp=-M^2
Id,Count,0,NOM,-2,Two,-4,Nom,-2,Nohm,-2,[m2-M2],2,p,1,k,1,pp,1,kp,1,q,1,m,1

*yep
C Working out of shifted 1/(q^2+m^2)^n

IF Nohm^n~*Sh1=Fxx(-2*n,0,0,n)*Sh1
OR Nohm^n~*Sh2=Fxx(-2*n,0,0,n)*Sh2
OR Nohm^n~*Sh3=Fxx(-2*n,0,0,n)*Sh3
OR Nohm^n~*Sh4=Fxx(-2*n,0,0,n)*Sh4
OR Nohm^n~*Sh5=Fxx(-2*n,0,0,n)*Sh5
OR Nohm^n~*Sh6=Fxx(-2*n,0,0,n)*Sh6
OR Nohm^n~*Sh7=Fxx(-2*n,0,0,n)*Sh7

COUNT{}

Id,Sh1*Fxx(n1~,n2~,n3~,n4~)=Fdiv(n1,n2,n3)*Exp(n1,n2,n3,(2*qDp),n4)
Al,Sh2*Fxx(n1~,n2~,n3~,n4~)=Fdiv(n1,n2,n3)*
 Exp(n1,n2,n3,(2*qDp+2*qDpp-2*pDpp),n4)
Al,Sh3*Fxx(n1~,n2~,n3~,n4~)=Fdiv(n1,n2,n3)*Exp(n1,n2,n3,(-2*qDk),n4)
Al,Sh4*Fxx(n1~,n2~,n3~,n4~)=Fdiv(n1,n2,n3)
 *Exp(n1,n2,n3,(-2*qDk-2*qDpp-2*kDpp),n4)
Al,Sh5*Fxx(n1~,n2~,n3~,n4~)=Fdiv(n1,n2,n3)
 *Exp(n1,n2,n3,(-2*qDk-2*qDp-2*kDp),n4)
Al,Sh6*Fxx(n1~,n2~,n3~,n4~)=Fdiv(n1,n2,n3)*Exp(n1,n2,n3,(2*qDpp),n4)
Al,Sh7*Fxx(n1~,n2~,n3~,n4~)=Fdiv(n1,n2,n3)*Exp(n1,n2,n3,(2*qDkp),n4)
ENDIF

Id,pDp=-M^2
Al,kDk=-M^2
Al,ppDpp=-M^2
Al,kpDkp=-M^2
Al,qDkp=-qDk-qDp-qDpp
Id,Count,0,NOM,-2,Two,-4,Nom,-2,Nohm,-2,[m2-M2],2,p,1,k,1,pp,1,kp,1,q,1,m,1

Id,Multi,Chsi^2=1
IF Chsi=1
Al,qDq=qDq
Al,Dotpr,q(al~)=-q(al)
ENDIF

ENDBLOCK


BLOCK STINT{}
C Standard integrals.

C Type Fn = 1/(q^2+M^2)^n

Id,F(1,m2~) = 2*i*Pi^2*m2/N_ + i*Pi^2*m2*(-1+Log(m2))
Al,F(2,m2~) = - 2*i*Pi^2/N_ - i*Pi^2*Log(m2)
Al,F(3,m2~) = 0.5*i*Pi^2/m2
Al,F(4,m2~) = i*Pi^2/6/m2^2
Al,F(5,m2~) = 1/12*i*Pi^2*m2^-3
Al,F(6,m2~) = 1/20*i*Pi^2*m2^-4
Al,F(7,m2~) = 1/30*i*Pi^2*m2^-5

Id,G(1,m2~) = - 0.5*i*Pi^2*m2^2/N_ + 3/8*i*Pi^2*m2^2
  - 0.25*i*Pi^2*m2^2*Log(m2)

Al,G(2,m2~) = i*Pi^2 * ( - 1/2*m2 + m2*N_^-1 )
 + 0.5*m2*Log(m2)*i*Pi^2

Al,G(3,m2~) = i*Pi^2 * ( - 1/2*N_^-1 )
 - 1/4*Log(m2)*i*Pi^2

Al,G(4,m2~) = 1/12*i*Pi^2*m2^-1

Al,G(5,m2~) = 1/48*i*Pi^2*m2^-2

Al,G(6,m2~) = 1/120*i*Pi^2*m2^-3

Al,G(7,m2~) = 1/240*i*Pi^2*m2^-4

Id,H(1,m2~) = 1/12*i*Pi^2*m2^3/N_ - 11/144*i*Pi^2*m2^3
 + 1/24*i*Pi^2*m2^3*Log(m2)

Al,H(2,m2~) = i*Pi^2 * ( 3/16*m2^2 - 1/4*m2^2*N_^-1 )
 - 1/8*Log(m2)*i*Pi^2*m2^2

Al,H(3,m2~) = i*Pi^2 * ( - 1/8*m2 + 1/4*m2*N_^-1 )
 + 1/8*Log(m2)*i*Pi^2  *m2

Al,H(4,m2~) = - 1/12*i*Pi^2*N_^-1
 - 1/24*Log(m2)*i*Pi^2

Al,H(5,m2~) = i*Pi^2/96/m2

Al,H(6,m2~) = 1/480*i*Pi^2*m2^-2

Al,H(7,m2~) = 1/1200*i*Pi^2*m2^-3

C Type Fnm = 1/[(q^2+M^2)^n*(q^2+m^2)^m]

Id,F(1,1,M2,m2) = - 2*i*Pi^2/N_
  + i*Pi^2*{ 1 - m2*Log(m2)/[m2-M2] + M2*Log(M2)/[m2-M2]}

Al,F(1,2,M2,m2) = i*Pi^2*{ 1/[m2-M2] - M2*Log(m2,M2)/[m2-M2]^2}

Al,F(2,2,M2,m2) = - 2*i*Pi^2*[m2-M2]^-2
 + Log(m2,M2)*i*Pi^2 * ( 2*M2*[m2-M2]^-3 + [m2-M2]^-2 )
 
Al,F(1,3,M2,m2) = 0.5*i*Pi^2*{ 1/[m2-M2]^2 + M2/m2/[m2-M2]^2
  - 2*M2*Log(m2,M2)/[m2-M2]^3 }

Al,F(2,3,M2,m2) = i*Pi^2 * ( 1/4*M2^-2*m2^-1 - 1/4*M2^-2*[m2-M2]^-1
   + 1/4*M2^-1*[m2-M2]^-2 - 3/2*[m2-M2]^-3 )
 + Log(m2,M2)*i*Pi^2 * ( 3/2*M2*[m2-M2]^-4 + 1/2*[m2-M2]^-3 )

Al,F(3,3,M2,m2) = i*Pi^2
  * ( 1/4*M2^-3*m2^-1 - 1/4*M2^-3*[m2-M2]^-1 + 1/4*M2^-2*[m2-M2]^-2
   + 3*[m2-M2]^-4 )
 + Log(m2,M2)*i*Pi^2 * ( - 3*M2*[m2-M2]^-5 - 3/2*[m2-M2]^-4 )

Al,F(1,4,M2,m2) = i*Pi^2/6*{ 2/[m2-M2]^3 + 5*M2/m2/[m2-M2]^3
 - M2^2/m2^2/[m2-M2]^3 - 6*M2*Log(m2,M2)/[m2-M2]^4 }

Al,F(2,4,M2,m2) = + i*Pi^2
  * ( - 2/3*M2^-3*m2^-1 + 2/3*M2^-3*[m2-M2]^-1 + 1/6*M2^-2*m2^-2
  - 5/6*M2^-2*[m2-M2]^-2 + M2^-1*[m2-M2]^-3 - 4*[m2-M2]^-4 )
 + Log(m2,M2)*i*Pi^2 * ( 4*M2*[m2-M2]^-5 + [m2-M2]^-4 )

Al,F(3,4,M2,m2) = i*Pi^2
  * ( - M2^-4*m2^-1 + M2^-4*[m2-M2]^-1 + 1/6*M2^-3*m2^-2 - 7/6*M2^-3
  *[m2-M2]^-2 + 4/3*M2^-2*[m2-M2]^-3 - M2^-1*[m2-M2]^-4 + 10*
 [m2-M2]^-5 )
 + Log(m2,M2)*i*Pi^2 * ( - 10*M2*[m2-M2]^-6 - 4*[m2-M2]^-5 )

Al,F(4,4,M2,m2) = i*Pi^2
  * ( - 2/3*M2^-4*m2^-1 + 2/3*M2^-4*[m2-M2]^-1 + 1/9*M2^-3*m2^-2
  - 7/9*M2^-3*[m2-M2]^-2 + 8/9*M2^-2*[m2-M2]^-3 - 2/3*M2^-1*
 [m2-M2]^-4 + 20/3*[m2-M2]^-5 )
 + Log(m2,M2)*i*Pi^2 * ( - 20/3*M2*[m2-M2]^-6 - 8/3*[m2-M2]^-5 )

C Type Gnm = q(mu)*q(nu)/[(q^2+M^2)^n*(q^2+m^2)^m]
  Function D(mu,nu) understood.

Id,G(1,1,M2,m2) = + 0.5*i*Pi^2*(m2+M2)/N_ - 3*i*Pi^2*(m2+M2)/8
  + 0.25*i*Pi^2*(m2^2*Log(m2) - M2^2*Log(M2))/[m2-M2]

Al,G(1,2,M2,m2) = i*Pi^2*( 1/8 - 1/4*M2*[m2-M2]^-1 - 1/2*N_^-1 )
 + 0.25*Log(m2,M2)*i*Pi^2*M2^2*[m2-M2]^-2
 - 1/4*Log(m2)*i*Pi^2

Al,G(2,2,M2,m2) = i*Pi^2 * ( 1/2*M2*[m2-M2]^-2 + 1/4*[m2-M2]^-1 )
 + Log(m2,M2)*i*Pi^2 * ( - 1/2*M2*[m2-M2]^-2 - 1/2*M2^2*[m2-M2]^-3 )

Al,G(1,3,M2,m2) = i*Pi^2*( - 1/4*M2*[m2-M2]^-2 + 1/8*[m2-M2]^-1 )
 + 1/4*Log(m2,M2)*i*Pi^2*M2^2*[m2-M2]^-3

Al,G(2,3,M2,m2) = i*Pi^2 * ( 3/4*M2*[m2-M2]^-3 + 1/8*[m2-M2]^-2 )
 + Log(m2,M2)*i*Pi^2 * ( - 1/2*M2*[m2-M2]^-3 - 3/4*M2^2*[m2-M2]^-4 )

Al,G(3,3,M2,m2) = + i*Pi^2 * ( - 3/2*M2*[m2-M2]^-4 - 3/4*[m2-M2]^-3 )
 + Log(m2,M2)*i*Pi^2
  * ( 3/2*M2*[m2-M2]^-4 + 3/2*M2^2*[m2-M2]^-5 + 1/4*[m2-M2]^-3 )

Al,G(1,4,M2,m2) = i*Pi^2 * ( - 1/4*M2*[m2-M2]^-3 + 1/12*M2^-1*m2^-1
 - 1/12*M2^-1*[m2-M2]^-1 + 1/8*[m2-M2]^-2 )
 + 1/4*Log(m2,M2)*i*Pi^2*M2^2*[m2-M2]^-4

Al,G(2,4,M2,m2) = i*Pi^2
  * ( M2*[m2-M2]^-4 + 1/12*M2^-2*m2^-1 - 1/12*M2^-2*[m2-M2]^-1
  + 1/12*M2^-1*[m2-M2]^-2 ) 
 + Log(m2,M2)*i*Pi^2  * ( - 1/2*M2*[m2-M2]^-4 - M2^2*[m2-M2]^-5 )

Al,G(3,4,M2,m2) = i*Pi^2
  * ( - 5/2*M2*[m2-M2]^-5 + 1/12*M2^-3*m2^-1 - 1/12*M2^-3*
 [m2-M2]^-1 + 1/12*M2^-2*[m2-M2]^-2 - 1/12*M2^-1*[m2-M2]^-3
  - 3/4*[m2-M2]^-4 )
 + Log(m2,M2)*i*Pi^2
  * ( 2*M2*[m2-M2]^-5 + 5/2*M2^2*[m2-M2]^-6 + 1/4*[m2-M2]^-4 )

Al,G(4,4,M2,m2) = i*Pi^2
  * ( 5*M2*[m2-M2]^-6 + 1/12*M2^-4*m2^-1 - 1/12*M2^-4*[m2-M2]^-1
  + 1/12*M2^-3*[m2-M2]^-2 - 1/12*M2^-2*[m2-M2]^-3 + 1/6*M2^-1*
 [m2-M2]^-4 + 5/2*[m2-M2]^-5 )
 + Log(m2,M2)*i*Pi^2
  * ( - 5*M2*[m2-M2]^-6 - 5*M2^2*[m2-M2]^-7 - [m2-M2]^-5 )


C Type Hnm = q(mu)*q(nu)*q(al)*q(be)/[(q^2+M^2)^n*(q^2+m^2)^m]
  Function d(mu,nu,al,be)
    = D(mu,nu)*D(al,be) + D(mu,al)*D(nu,be) + D(mu,be)*D(nu,de)
  understood. Derived from
  H11(M2,m2) = {- m2*F1(m2) - M2*F1(M2) + m2*M2*F11(M2,m2)}/[N^2+2*N]

Id,H(1,1,M2,m2) = i*Pi^2 * ( 11/144*M2*m2 - 1/12*M2*m2*N_^-1 + 11/144*M2^2
   - 1/12*M2^2*N_^-1 + 11/144*m2^2 - 1/12*m2^2*N_^-1 )
  - 1/24*Log(m2,M2)*i*Pi^2*M2^3*[m2-M2]^-1
  + Log(m2)*i*Pi^2*( - 1/24*M2*m2 - 1/24*M2^2 - 1/24*m2^2 )

Al,H(1,2,M2,m2) = i*Pi^2 * ( - 5/144*M2 + 1/12*M2*N_^-1
  + 1/24*M2^2*[m2-M2]^-1 - 1/9*m2 + 1/6*m2*N_^-1 )
  -1/24*Log(m2,M2)*i*Pi^2*M2^3*[m2-M2]^-2
  + Log(m2)*i*Pi^2* ( 1/24*M2 + 1/12*m2 )

Al,H(2,2,M2,m2) = i*Pi^2
  * ( 5/144 - 1/12*M2*[m2-M2]^-1 - 1/12*M2^2*[m2-M2]^-2 - 1/12*N_^-1 )
 + Log(m2,M2)*i*Pi^2 * ( 1/8*M2^2*[m2-M2]^-2 + 1/12*M2^3*[m2-M2]^-3 )
 - 1/24*Log(m2)*i*Pi^2

Al,H(1,3,M2,m2) = i*Pi^2
  * ( 1/72 - 1/48*M2*[m2-M2]^-1 + 1/24*M2^2*[m2-M2]^-2 - 1/12*N_^-1 )
  -1/24*Log(m2,M2)*i*Pi^2*M2^3*[m2-M2]^-3
 - 1/24*Log(m2)*i*Pi^2

Al,H(2,3,M2,m2) = i*Pi^2
  * ( - 1/16*M2*[m2-M2]^-2 - 1/8*M2^2*[m2-M2]^-3 + 1/48*[m2-M2]^-1 )
 + Log(m2,M2)*i*Pi^2
  * ( 1/8*M2^2*[m2-M2]^-3 + 1/8*M2^3*[m2-M2]^-4 )

Al,H(3,3,M2,m2) = i*Pi^2
  * ( 1/4*M2*[m2-M2]^-3 + 1/4*M2^2*[m2-M2]^-4 + 1/48*[m2-M2]^-2 )
 + Log(m2,M2)*i*Pi^2
  * ( - 1/8*M2*[m2-M2]^-3 - 3/8*M2^2*[m2-M2]^-4 - 1/4*M2^3*
 [m2-M2]^-5 )

Al,H(1,4,M2,m2) = + i*Pi^2
  * ( - 1/48*M2*[m2-M2]^-2 + 1/24*M2^2*[m2-M2]^-3 + 1/72*[m2-M2]^-1 )
  -1/24*Log(m2,M2)*i*Pi^2*M2^3*[m2-M2]^-4
 
Al,H(2,4,M2,m2) = + i*Pi^2
  * ( - 1/24*M2*[m2-M2]^-3 - 1/6*M2^2*[m2-M2]^-4 + 1/144*[m2-M2]^-2 )
 + Log(m2,M2)*i*Pi^2 * ( 1/8*M2^2*[m2-M2]^-4 + 1/6*M2^3*[m2-M2]^-5 )

Al,H(3,4,M2,m2) = i*Pi^2
  * ( 7/24*M2*[m2-M2]^-4 + 5/12*M2^2*[m2-M2]^-5 + 1/72*[m2-M2]^-3 )
 + Log(m2,M2)*i*Pi^2
  * ( - 1/8*M2*[m2-M2]^-4 - 1/2*M2^2*[m2-M2]^-5 - 5/12*M2^3*
 [m2-M2]^-6 )

Al,H(4,4,M2,m2) = i*Pi^2
  * ( - 5/6*M2*[m2-M2]^-5 - 5/6*M2^2*[m2-M2]^-6 - 11/72*[m2-M2]^-4 )
 + Log(m2,M2)*i*Pi^2
  * ( 1/2*M2*[m2-M2]^-5 + 5/4*M2^2*[m2-M2]^-6 + 5/6*M2^3*[m2-M2]^-7
   + 1/24*[m2-M2]^-4 )

ENDBLOCK

End
