C Radiative corrections to WW production by e+e-.
  Calculation of the contribution due to a fermion generation.

C e+e- => WW. 1. W selfenergy, minimal subtraction terms.
C e+e- => WW. 2. W selfenergy due to a fermion generation.
		 Writes common file Self.
C e+e- => WW. 3. Approximation for high energy of selfenergy correction.
		 Uses common file Self.
C e+e- => WW. 4. WWW vertex contribution due to a fermion generation.
		 Writes common file Vertex.
C e+e- => WW. 5. Approximation for high energy of WWW vertex correction.
		 Uses common file Vertex.
C e+e- => WW. 6. Approximation for large equal masses of selfenerg correction.
		 Uses common file Self.
C e+e- => WW. 7. Approximation for large equal masses of WWW vertex correction.
		 Uses common file Vertex.

*end

C e+e- => WW. 1. W selfenergy, minimal subtraction terms.

P ninput
Read Standb.e
NAMES{}
VERT{}
*fix

Z IWW = SELF("W,"W)

B i,Pi,N_

Id,SELF(I1~,I2~)=
   DS(I1;-J1;J2;Sym;-J1;J2,TAP,3,(DIB(I1,J1,J2,I2)
  *DC("F,TFE,-1,J1,J2) ))
 + DS(I1;J3;-J3;I2;Sym;J3;-J3,TAP,3,(DIC(I1,J3,I2) ))

Id,DIB(I1~,K1~,K2~,I2~)=
   VE3(I1,-K1,K2,*,mu,lA,cA,q,*,L1,1,c1,-K,*,L4,4,c4,Q)*
   VE3(K1,I2,-K2,*,L3,3,c3,K,*,nu,lB,cB,-q,*,L2,2,c2,-Q)*
   PROP(K1,-K1,*,L1,1,c1,K,*,L3,3,c3,-K)*
   PROP(K2,-K2,*,L2,2,c2,Q,*,L4,4,c4,-Q)
Id,DIC(I1~,K1~,I2~)=
   VE4(I1,K1,-K1,I2,*,mu,*,L1,*,L2,*,nu)*
   PROP(K1,-K1,*,L1,1,c1,Q,*,L2,2,c2,-Q)
Id,Compo,<X>,VE4,VE3,PROP
*yep
Id,VE4(Ax~,L1~,L2~,L3~,L4~)=Ax(L1,L2,L3,L4)
Al,VE3(Ax~,L1~,l1~,c1~,K~,L2~,l2~,c2~,Q~,L3~,l3~,c3~,P~)=
       Ax(L1,l1,c1,K,L2,l2,c2,Q,L3,l3,c3,P)
Al,PROP(Ax~,L4~,l4~,c4~,Q~,L3~,l3~,c3~,P~)=Ax(L4,l4,c4,L3,l3,c3,P)
Id,Even,NOM
Id,Commu,NOM
Id,NOM(Q,M~)*NOM(K,M0~)=Bx(M,M0)
Al,NOM(Q,M~)=Ax(M)
Al,Multi,Sqrt2^-2=1/2
Id,Gammas,"C
*yep
Id,Funct,K(L1~)=Q(L1)+q(L1)
Al,Dotpr,K(L1~)=Q(L1)+q(L1)
Al,K(L1~)=Q(L1)+q(L1)
Id,All,Q,N,Fx
*yep
Id,Bx(M~,M0~)*Fx(L1~,L2~)=D(L1,L2)*B22(qDq,M,M0)+q(L1)*q(L2)*B21(qDq,M,M0)
Al,Bx(M~,M0~)*Fx(L1~)=q(L1)*B1(qDq,M,M0)
Al,Bx(M~,M0~)=B0(qDq,M,M0)
*yep
Id,Gammas,"A
*yep

Id,B22(x~,M~,m~)=(-0.5*Ax(m)+M**2*B0(x,M,m)
      -0.5*(x+m^2-M**2)*B1(x,M,m))/[1-N]
Id,B21(x~,M~,m~)=-((0.5*N-1)*Ax(m)
       -0.5*N*(x+m^2-M**2)*B1(x,M,m)
       +M**2*B0(x,M,m) )/x/[1-N]
Id,B1(x~,M~,m~)= (0.5*Ax(M)-0.5*Ax(m)
              -0.5*(x+m^2-M**2)*B0(x,M,m) )/x


Id,Ax(PM)=0.
Al,Ax(M~) = 2*i*Pi^2*M^2/N_ + i*Pi^2*M^2*(-1+Log(M))

Id,Symme,B0,2,3
Id,B0(u~,M~,m~) = - 2*N_^-1*i*Pi^2 + B0f(u,M,m)
Id,N=N_+4
Al,[1-N]^-1=-1/3 + N_/9
Id,N_=0
Id,N=4

Id,PM=0.
Al,Multi,M0**2=M**2/C**2
Al,[C^2-S^2]=2*C**2-1
Al,[4/3*S^2-1]=1/3-4/3*C^2
Al,[1-8/3*S^2]=8/3*C^2-5/3
Al,[4*S^2-1]=3-4*C^2

Id,Multi,C**2=1.-S**2
Id,Multi,S**2=1.-C**2
P output
P stats
*yep
P input
C Minimal subtraction terms.
P ninput

IF NOT B0f(u~,m,m) = B0HF(u)
Id,B0f(u~,M~,m) = i*Pi^2
 + i*Pi^2*m^-4* ( - 3/2*u*M^2 + 1/6*u^2 )
 + i*Pi^2*m^-2 * ( - 1/2*u )
 - Log(m)*i*Pi^2
 + Log(m)*i*Pi^2*m^-4 * ( u*M^2 - M^4 )
 - Log(m)*i*Pi^2*m^-2*M^2
 + Log(M)*i*Pi^2*m^-4 * ( - u*M^2 + M^4 )
 + Log(M)*i*Pi^2*m^-2*M^2
ENDIF
Id,B0f(u~,M~,M0~) = i*Pi^2
Id,Log(m) = x*Log(m)
Id,Count,1,N_,-1,m,1,x,1,B0HF,10
Id,x=1
Id,M0=M/C
B i,Pi,N_
P output
*yep
P input
C Zero weak mixing angle.
Id,C^n~=1
*end

C e+e- => WW. 2. W selfenergy due to a fermion generation.

P ninput
Read Standb.e
NAMES{}
VERT{}
*fix

Common IWW

Z IWW(mu,nu) = SELF("W,"W)

B i,Pi,N_

Id,SELF(I1~,I2~)=
   DS(I1;-J1;J2;Sym;-J1;J2,TAP,3,4,(DIB(I1,J1,J2,I2)
  *DC("F,TFE,-1,J1,J2) ))
 + DS(I1;J3;-J3;I2;Sym;J3;-J3,TAP,3,4,(DIC(I1,J3,I2) ))

Id,DIB(I1~,K1~,K2~,I2~)=
   VE3(I1,-K1,K2,*,mu,lA,cA,q,*,L1,1,c1,-K,*,L4,4,c4,Q)*
   VE3(K1,I2,-K2,*,L3,3,c3,K,*,nu,lB,cB,-q,*,L2,2,c2,-Q)*
   PROP(K1,-K1,*,L1,1,c1,K,*,L3,3,c3,-K)*
   PROP(K2,-K2,*,L2,2,c2,Q,*,L4,4,c4,-Q)
Id,DIC(I1~,K1~,I2~)=
   VE4(I1,K1,-K1,I2,*,mu,*,L1,*,L2,*,nu)*
   PROP(K1,-K1,*,L1,1,c1,Q,*,L2,2,c2,-Q)
Id,Compo,<X>,VE4,VE3,PROP
Id,VE4(Ax~,L1~,L2~,L3~,L4~)=Ax(L1,L2,L3,L4)
Al,VE3(Ax~,L1~,l1~,c1~,K~,L2~,l2~,c2~,Q~,L3~,l3~,c3~,P~)=
       Ax(L1,l1,c1,K,L2,l2,c2,Q,L3,l3,c3,P)
Al,PROP(Ax~,L4~,l4~,c4~,Q~,L3~,l3~,c3~,P~)=Ax(L4,l4,c4,L3,l3,c3,P)
Id,Even,NOM
Id,Commu,NOM
Id,NOM(Q,M~)*NOM(K,M0~)=Bx(M,M0)
Al,NOM(Q,M~)=Ax(M)
Al,Multi,Sqrt2^-2=1/2
Id,Gammas,"C
*yep
Id,Funct,K(L1~)=Q(L1)+q(L1)
Al,Dotpr,K(L1~)=Q(L1)+q(L1)
Al,K(L1~)=Q(L1)+q(L1)
Id,All,Q,N,Fx
*yep
Id,Bx(M~,M0~)*Fx(L1~,L2~)=D(L1,L2)*B22(qDq,M,M0)+q(L1)*q(L2)*B21(qDq,M,M0)
Al,Bx(M~,M0~)*Fx(L1~)=q(L1)*B1(qDq,M,M0)
Al,Bx(M~,M0~)=B0(qDq,M,M0)
*yep
Id,Gammas,"A
*yep

Id,B22(x~,M~,m~)=(-0.5*Ax(m)+M**2*B0(x,M,m)
      -0.5*(x+m^2-M**2)*B1(x,M,m))/[1-N]
Id,B21(x~,M~,m~)=-((0.5*N-1)*Ax(m)
       -0.5*N*(x+m^2-M**2)*B1(x,M,m)
       +M**2*B0(x,M,m) )/x/[1-N]
Id,B1(x~,M~,m~)= (0.5*Ax(M)-0.5*Ax(m)
              -0.5*(x+m^2-M**2)*B0(x,M,m) )/x


Id,Ax(PM)=0.
Al,Ax(M~) = 2*i*Pi^2*M^2/N_ + i*Pi^2*M^2*(-1+Log(M))

Id,Symme,B0,2,3

Id,B0(u~,M~,m~) = - 2*i*Pi^2/N_ + B0f(u,M,m)

Id,N=N_+4
Al,[1-N]^-1=-1/3 + N_/9
Id,N_=0
Id,N=4

Id,PM=0.
Al,Multi,M0**2=M**2/C**2
Al,[C^2-S^2]=2*C**2-1
Al,[4/3*S^2-1]=1/3-4/3*C^2
Al,[1-8/3*S^2]=8/3*C^2-5/3
Al,[4*S^2-1]=3-4*C^2

Id,Multi,C**2=1.-S**2
Id,Multi,S**2=1.-C**2
C Zero weak mixing angle.
Id,C^n~=1
B i,Pi,N_
P stats
*begin
Write Self
*end

C e+e- => WW. 3. Approximation for high energy of selfenergy correction.
  Uses output from 2.

P ninput

Read Standb.e
NAMES{}
Enter Self
*fix

Z IZZ=IWW(mu,nu)

*yep
B Wave,i,Pi,N_
Id,q(al~)*q(be~)=Wave*q(al)*q(be) + qDq*D(al,be)
Id,qDq^n~=(-1)^n*E^(2*n)

Id,Md=0
Al,Me=0
Al,Mn=0
Id,B0(u~,Me,m~)=B0(u,0,m)
Al,B0(u~,Mn,m~)=B0(u,0,m)
Al,B0(u~,Md,m~)=B0(u,0,m)
Id,B0(u~,m~,Me)=B0(u,m,0)
Al,B0(u~,m~,Mn)=B0(u,m,0)
Al,B0(u~,m~,Md)=B0(u,m,0)
*yep
Id,B0f(qDq,0,0)=2*i*Pi^2 - i*Pi^2*Log(s)
Al,B0f(pDp,Mu,0)=i*Pi^2 *(1-Log(Mu)+del/2-del^2/6)
C Al,B0f(qDq,Mu,Mu)=
 i*Pi^2*(2-Log(s)-2*eps*Log(eps)+2*eps-2*eps^2*Log(eps)-eps^2)
Id,eps=Mu^2/s
Al,del=M^2/Mu^2
Id,s^n~=E^(2*n)
Al,Log(s)=Log(Mu)-Log(eps)
C Id,Count,2,s,2,Mu,1,E,1,N_,-10,g0,10,Error,10

*end

C e+e- => WW. 4. WWW vertex contribution due to a fermion generation.

P ninput

Read Standb.e
NAMES{}
VERT{}
*fix

Common IWWpWm

BLOCK DIV{}
Id,Ax(u~)=-u^2*DEL
Al,B0(u~,m~,M~)=DEL
Al,B1(u~,m~,M~)=-1/2*DEL
Al,B21(u~,m~,M~)=DEL/3
Al,B0(u~,m~,M~)=-(u/12+m^2/4+M^2/4)*DEL
Al,C24(m~,M~,M0~)=DEL/4
Al,C35(m~,M~,M0~)=-DEL/6
Al,C36(m~,M~,M0~)=-DEL/12
IF NOT DEL
Id,Addfa,0
ENDIF
*yep
ENDBLOCK

BLOCK KINE{}
Id,Epf(al~,be~,ga~,de~)=0
Id,pDep=0
Al,kDek=0
Al,qDep=-E*r/M
Al,kDep=E*r/M
Al,qDek=-E*r/M
Al,pDek=E*r/M
Al,epDek=-s/M^2/2+1
Id,r^2=s/4-M^2
Al,pDk=-s/2+M^2
Al,qDq^n~=(-1)^n*s^n
Al,qDp=s/2
Al,qDk=s/2
Al,pDp^n~=(-1)^n*M^(2*n)
Al,kDk^n~=(-1)^n*M^(2*n)
Al,Multi,E^2=s
ENDBLOCK

BLOCK KINE1{}
Id,Epf(al~,be~,ga~,de~)=0
Al,Me=0
Al,Md=0
Al,B0(u~,Me,m~)=B0(u,0,m)
Al,B0(u~,Md,m~)=B0(u,0,m)
Id,B0(u~,m~,Me)=B0(u,m,0)
Al,B0(u~,m~,Md)=B0(u,m,0)
Id,pDep=0
Al,kDek=0
Al,qDep=-E*r/Mx
Al,kDep=E*r/Mx
Al,qDek=-E*r/My
Al,pDek=E*r/My
Al,epDek= - s/2/Mx/My + 1/2*Mx/My + 1/2*Mx/My
Id,r^2=s/4-1/2*Mx^2-1/2*My^2+(Mx^4+My^4-2*Mx^2*My^2)/4/s
Al,pDk=-s/2+Mx^2/2+My^2/2
Al,qDq^n~=(-1)^n*s^n
Al,qDp=s/2+1/2*Mx^2-1/2*My^2
Al,qDk=s/2-1/2*Mx^2+1/2*My^2
Al,pDp^n~=(-1)^n*Mx^(2*n)
Al,kDk^n~=(-1)^n*My^(2*n)
Al,Multi,E^2=s
ENDBLOCK

BLOCK CASE{}
Id,Mx^n~=M^n
Al,My^n~=M^n
Al,d1= 1 - 2*r/E
Al,d2= 1 - 2*r/E
Al,B0(kDk,m~,M~)=B0(pDp,m,M)
ENDBLOCK

BLOCK CASE2{}
Id,Mx^n~=M^n
Al,My^n~=M^n/C^n
ENDBLOCK

F C11,C12,C21,C22,C23,C24,C31,C32,C33,C34,C35,C36
V ep,ek
A r,s,d

C Values of dot-products in q-restframe.
  q = (0,0,0,iE), p = (0,0,-r,-i*E/2), k = (0,0,r,-i*E/2)
  ep = (0,0,E/2,i*r)/M, ek = (0,0,-E/2,i*r)/M
  E^2/4 = r^2 + M^2, i.e. r^2 = E^2/4 - M^2
  (q,ep) = -E*r/M, (p,ep) =0,  (k,ep) = E*r/M
  (q,ek) = -E*r/M, (p,ek) = E*r/M, (k,ek) = 0.
  (ep,ek) = (- E^2/4 - r^2)/M^2 = (- E^2/2 + M^2)/M^2 = - s/2/M^2 + 1
  (pq) = (kq) = E^2/2 = s/2
  (pk) = - r^2 - E^2/4 = - r^2 - s/4 = M^2 - s/2
  Det = pDp*kDk - (pDk)^2 = M^4 - (M^2 - E^2/2)^2 = - s*r^2

 In the general case, if not kDk=pDp then (with pDp=-Mx^2, kDk=-My^2):
  q = (0,0,0,iE), p = (0,0,-r,-i*E1/2), k = (0,0,r,-i*E2/2)
  ep = (0,0,E1,i*r)/Mx, ek = (0,0,-E2,i*r)/My
  r^2 = { (E^2 - Mx^2 - My^2)^2 - 4*Mx^2*My^2 } / (4*E^2)
  With  (E1+E2)^2=E^2,  E1^2 = r^2 + Mx^2,  E2^2 = r^2 + My^2,
   E1*E2 = 1/2*(E^2 - Mx^2 - My^2 - 2*r^2);
 Dotproducts:
  (q,ep) = -E*r/Mx, (p,ep) =0,  (k,ep) = - (q,ep) = E*r/Mx
  (q,ek) = -E*r/My, (p,ek) = - (q,ek) = E*r/My, (k,ek) = 0.
  (ep,ek) = (- E1*E2 - r^2)/Mx/My = ( - E^2/2 + 1/2*Mx^2 + 1/2*My^2)/Mx/My
          = - s/2/Mx/My + 1/2*Mx/My + 1/2*My/Mx
  (pk) = 1/2*(Mx^2 + My^2 - E^2) = 1/2*Mx^2 + 1/2*My^2 - s/2
  (pq) = E^2/2 + 1/2*Mx^2 - 1/2*My^2 = s/2 + 1/2*Mx^2 - 1/2*My^2
  (kq) = E^2/2 + 1/2*My^2 - 1/2*Mx^2 = s/2 + 1/2*My^2 - 1/2*Mx^2
  Since pDk = 1/2*(qDq - pDp - kDk) = - 1/2*(E^2 - Mx^2 -My^2) it follows
    Det = Mx^2*My^2 - pDk^2 = - E^2*r^2 = - s*r^2
 Note that there are really only two independent vectors in this case
 (longitudinal polarizations).

Z IWWpWm(mu) = VERT("W,"U_,"U)*ep(al)*ek(be)

B i,Pi,N_

Id,VERT(K1~,K2~,K3~)=
  g0*16*Pi^4*i*
 VE3(K1,K2,K3,*,mu,lA,cA,q,*,al,lB,cB,p,*,be,lC,cC,k)

 +DS(K1;J3;-J1;TAP,3,4,(DS(K2;J1;-J2;TAP,3,4,(
  DIB(K1,K2,K3,J1,J2,J3)*DC("F,TFE,-1,J1,J2,J3) ))))

 +DS(K1;K2;-J4;J5;Sym;-J4;J5;TAP,3,4,(VIR1(K1,K2,K3,J4,J5) ))

 +DS(K2;K3;J6;-J7;Sym;J6;-J7;TAP,3,4,(VIR2(K1,K2,K3,J6,J7) ))

 +DS(K1;K3;-J8;J9;Sym;-J8;J9;TAP,3,4,(VIR3(K1,K2,K3,J8,J9) ))

C External momenta: q (left in), p (upper right in), k (lower rigth in).
  Internal momenta:
  Q = loop momentum.
  P = Q + p
  K = Q - q
  Q1= Q - k

C Triangle, K1 coming in from left, K2 in upper right, K3 in lower right.
  Inside, going clockwise:
  (3-vertex) 1 J1 5 (3-vertex) 2 J2 6 (3-vertex) 3 J3 4
  Internal momenta Q, P = Q + p, K = Q -q.

Id,DIB(K1~,K2~,K3~,J1~,J2~,J3~)=
   VE3(K1,-J1,J3,*,mu,lA,cA,q,*,L1,1,c1,-Q,*,L4,4,c4,K)*
   VE3(K2,J1,-J2,*,al,lB,cB,p,*,L5,5,c5,Q,*,L2,2,c2,-P)*
   VE3(K3,J2,-J3,*,be,lC,cC,k,*,L6,6,c6,P,*,L3,3,c3,-K)*
   PROP(J1,-J1,*,L1,1,c1,Q,*,L5,5,c5,-Q)*
   PROP(J2,-J2,*,L2,2,c2,P,*,L6,6,c6,-P)*
   PROP(J3,-J3,*,L3,3,c3,K,*,L4,4,c4,-K)

C Bubble in K3 = k line.
  (4-vertex) 1 J1 3 (3-vertex) 2 J2 4
  Internal momenta Q1 = Q - k and Q.

Al,VIR1(K1~,K2~,K3~,J1~,J2~)=
   VE4(K1,K2,-J1,J2,*,mu,*,al,*,L1,*,L4)*
   VE3(K3,J1,-J2,*,be,lC,cC,k,*,L3,3,c3,Q1,*,L2,2,c2,-Q)*
   PROP(J1,-J1,*,L1,1,c1,Q1,*,L3,3,c3,-Q1)*
   PROP(J2,-J2,*,L2,2,c2,Q,*,L4,4,c4,-Q)

C Bubble in K1 = q line.
  (3-vertex) 1 J1 3 (4-vertex) 2 J2 4
  Internal momenta Q and K = Q - q.

Al,VIR2(K1~,K2~,K3~,J1~,J2~)=
   VE4(K2,K3,J1,-J2,*,al,*,be,*,L3,*,L2)*
   VE3(K1,-J1,J2,*,mu,lA,cA,q,*,L1,1,c1,-Q,*,L4,4,c4,K)*
   PROP(J1,-J1,*,L1,1,c1,Q,*,L3,3,c3,-Q)*
   PROP(J2,-J2,*,L2,2,c2,K,*,L4,4,c4,-K)

C Bubble in K2 = p line.
  (4-vertex) 1 J1 3 (3-vertex) 2 J2 4
  Internal momenta Q and P = Q + p.

Al,VIR3(K1~,K2~,K3~,J1~,J2~)=
   VE4(K1,K3,-J1,J2,*,mu,*,be,*,L1,*,L4)*
   VE3(K2,J1,-J2,*,al,lB,cB,p,*,L3,3,c3,Q,*,L2,2,c2,-P)*
   PROP(J1,-J1,*,L1,1,c1,Q,*,L3,3,c3,-Q)*
   PROP(J2,-J2,*,L2,2,c2,P,*,L4,4,c4,-P)

Id,Anti,TAP

Id,Compo,<X>,VE4,VE3,PROP
Id,VE4(Ax~,L1~,L2~,L3~,L4~)=Ax(L1,L2,L3,L4)
Al,VE3(Ax~,L1~,l1~,c1~,K~,L2~,l2~,c2~,Q~,L3~,l3~,c3~,P~)=
       Ax(L1,l1,c1,K,L2,l2,c2,Q,L3,l3,c3,P)
Al,PROP(Ax~,L4~,l4~,c4~,Q~,L3~,l3~,c3~,P~)=Ax(L4,l4,c4,L3,l3,c3,P)

Id,Sqrt2^-2=1/2
Id,Even,NOM
Id,Commu,NOM
*yep

C Cx(M,m,M0) = 1/( Q^2 + M^2) / ((Q+p)^2 + m^2) / ((Q-k)^2 + M0^2)
  Bx(P,M,m) = 1/( Q^2 + M^2) / ( P^2 + M^2) where P may be Q1 = Q-k,
   K = Q-q  or  P = Q+p.

Id,Adiso,NOM(P,m~)*NOM(Q,M~)*NOM(K,M0~)=Cx(M,m,M0)
Al,Adiso,NOM(Q,M~)*NOM(P~,m~) = Bx(P,M,m)

Al,Multi,Sqrt2^-2=1/2
Id,Gammas,"C
*yep
P stats
Id,Funct,K(L1~)=Q(L1)-q(L1)
Al,Dotpr,K(L1~)=Q(L1)-q(L1)
Al,K(L1~)=Q(L1)-q(L1)
Id,Funct,P(L1~)=Q(L1)+p(L1)
Al,Dotpr,P(L1~)=Q(L1)+p(L1)
Al,P(L1~)=Q(L1)+p(L1)
Id,Funct,Q1(L1~)=Q(L1)-k(L1)
Al,Dotpr,Q1(L1~)=Q(L1)-k(L1)
Al,Q1(L1~)=Q(L1)-k(L1)
Id,All,Q,N,Fx
*yep
Id,Bx(M~,M0~)*Fx(L1~,L2~)=D(L1,L2)*B22(qDq,M,M0)+q(L1)*q(L2)*B21(qDq,M,M0)
Al,Bx(M~,M0~)*Fx(L1~)=q(L1)*B1(qDq,M,M0)
Al,Bx(M~,M0~)=B0(qDq,M,M0)
Id,Cx(m~,M~,M0~)*Fx(L1~,L2~,L3~) =
   p(L1)*p(L2)*p(L3)*C31(m,M,M0)
 + k(L1)*k(L2)*k(L3)*C32(m,M,M0)
 + (k(L1)*p(L2)*p(L3) + p(L1)*k(L2)*p(L3) + p(L1)*p(L2)*k(L3))*C33(m,M,M0)
 + (p(L1)*k(L2)*k(L3) + k(L1)*p(L2)*k(L3) + k(L1)*k(L2)*p(L3))*C34(m,M,M0)
 + (p(L1)*D(L2,L3) + p(L2)*D(L1,L3) + p(L3)*D(L1,L2))*C35(m,M,M0)
 + (k(L1)*D(L2,L3) + k(L2)*D(L1,L3) + k(L3)*D(L1,L2))*C36(m,M,M0)
Al,Cx(m~,M~,M0~)*Fx(L1~,L2~) =
   p(L1)*p(L2)*C21(m,M,M0)
 + k(L1)*k(L2)*C22(m,M,M0)
 + (p(L1)*k(L2) + k(L1)*p(L2))*C23(m,M,M0)
 + D(L1,L2)*C24(m,M,M0)
Al,Cx(m~,M~,M0~)*Fx(L1~) = p(L1)*C11(m,M,M0) + k(L1)*C12(m,M,M0)
Al,Cx(m~,M~,M0~)=C0(m,M,M0)

KINE{}
CASE{}
*yep
Id,Gammas,"A
KINE{}
CASE{}
*yep
Id,N=N_+4
Al,[1-N]^-1=-1/3 + N_/9
Id,Multi,N_^2=0
IF N_
Id,Ax(m~)*N_ = 2*i*Pi^2*m^2
Al,B0(u~,m~,M~)*N_ = - 2*i*Pi^2
Id,C24(m~,M~,M0~)*N_=-1/2*i*Pi^2
Al,C35(m~,M~,M0~)*N_=1/3*i*Pi^2
Al,C36(m~,M~,M0~)*N_=1/6*i*Pi^2
Id,N_=0
ENDIF
Id,M0^n~=M^n/C^n
Al,[C^2-S^2]=2*C**2-1
Al,[4/3*S^2-1]=1/3-4/3*C^2
Al,[1-8/3*S^2]=8/3*C^2-5/3
Al,[4*S^2-1]=3-4*C^2

Id,Multi,C**2=1.-S**2
Id,Multi,S**2=1.-C**2

C Simplification: neglect em.
Id,C^n~=1

KINE{}
CASE{}
*yep
C q(mu) when multiplied with the e+e- part will give mE ~ 0.
Id,q(al~)=0
C For longitudinal polarizations the polarization vectors can be
  written in terms of p, k and q.
  Definition:  d1 = 2*(E1 - r)/E,  d2 = 2*(E2 - r)/E.
  Some useful expansions for large E:
  r   = E/2*( 1 - Mx^2/E^2 - My^2/E^2 - 2*Mx^2*My^2/E^4 )
  1/r = 2/E*( 1 + Mx^2/E^2 + My^2/E^2 + (4*Mx^2*My^2+Mx^4+My^4)/E^4 )
  d1  = 2*Mx^2/E^2 + 2*Mx^2*My^2/E^4
  d2  = 2*My^2/E^2 + 2*Mx^2*My^2/E^4


Id,ep(al~)=-p(al)/Mx + E*d1/r/Mx/2*k(al)
C + E*d1*d2/4/Mx/r*q(al)
Al,ek(al~)=-k(al)/My + E*d2/r/My/2*p(al)
C + E*d1*d2/4/My/r*q(al)

Id,q(al~)=0
Al,k(al~)=-p(al)
KINE{}
CASE{}
Id,s=E^2
P output
*begin
Write Vertex
*end

C e+e- => WW. 5. Approximation for high energy of WWW vertex correction.
  Uses output of 4.

P ninput

Read Standb.e
NAMES{}
Enter Vertex
*fix

BLOCK KINE{}
Id,Epf(al~,be~,ga~,de~)=0
Al,Me=0
Al,Md=0
Al,Mn=0
Id,pDep=0
Al,kDek=0
Al,qDep=-E*r/M
Al,kDep=E*r/M
Al,qDek=-E*r/M
Al,pDek=E*r/M
Al,epDek=-s/M^2/2+1
Id,r^2=s/4-M^2
Al,pDk=-s/2+M^2
Al,qDq^n~=(-1)^n*s^n
Al,qDp=s/2
Al,qDk=s/2
Al,pDp^n~=(-1)^n*M^(2*n)
Al,kDk^n~=(-1)^n*M^(2*n)
Al,Multi,E^2=s
ENDBLOCK

BLOCK CASE{}
Id,Mx^n~=M^n
Al,My^n~=M^n
Al,d2=d1
Al,B0(kDk,m~,M~)=B0(pDp,m,M)
ENDBLOCK

Z IZWW = IWWpWm(mu)

*yep
Id,C0~(Md,Mx~,My~)=C0(0,Mx,My)
Al,C0~(Mn,Mx~,My~)=C0(0,Mx,My)
Id,C0~(Mx~,Md,My~)=C0(Mx,0,My)
Al,C0~(Mx~,Mn,My~)=C0(Mx,0,My)
Id,C0~(Mx~,My~,Md)=C0(Mx,My,0)
Al,C0~(Mx~,My~,Mn)=C0(Mx,My,0)

*yep
Id,C11(Mx~,My~,Mx~) = Det^-1*C0(Mx,My,Mx)
  * ( 1/4*Mx^2*qDq - 1/4*My^2*qDq + 1/4*pDp*qDq )
 - C0(Mx,My,Mx) + B0(pDp,Mx,My)*Det^-1 * ( - 1/4*qDq )
 + B0(qDq,Mx,Mx)*Det^-1 * ( 1/4*qDq )
 
Al,C12(Mx~,My~,Mx~) = Det^-1*C0(Mx,My,Mx)
  * ( - 1/4*Mx^2*qDq + 1/4*My^2*qDq - 1/4*pDp*qDq )
 + B0(pDp,Mx,My)*Det^-1 * ( 1/4*qDq )
 + B0(qDq,Mx,Mx)*Det^-1 * ( - 1/4*qDq )

Al,C21(Mx~,My~,Mx~) = i*Pi^2*Det^-1
  * ( - 1/4*pDp )
 + Det^-2*C0(Mx,My,Mx)
  * ( - 3/4*Mx^2*My^2*pDp*qDq + 3/4*Mx^2*pDp^2*qDq + 3/8*Mx^4*pDp*qDq
   - 3/4*My^2*pDp^2*qDq + 3/8*My^4*pDp*qDq + 3/8*pDp^3*qDq )
 + Det^-1*C0(Mx,My,Mx)
  * ( 1/2*Mx^2*My^2 - 1/2*Mx^2*pDp - 1/2*Mx^2*qDq - 1/4*Mx^4
  + My^2*pDp + 1/2*My^2*qDq - 1/4*My^4 - 1/2*pDp*qDq - 1/4*pDp^2 )
 + C0(Mx,My,Mx)
 + Ax(Mx)*Det^-1
  * ( 1/4 - 1/8*pDp^-1*qDq )
 + Ax(My)*Det^-1
  * ( - 1/4 + 1/8*pDp^-1*qDq )
 + B0(pDp,Mx,My)*Det^-2
  * ( - 3/8*Mx^2*pDp*qDq + 3/8*My^2*pDp*qDq - 3/8*pDp^2*qDq )
 + B0(pDp,Mx,My)*Det^-1
  * ( 1/2*Mx^2 - 1/8*Mx^2*pDp^-1*qDq - 1/2*My^2 + 1/8*My^2*pDp^-1*qDq
   + 1/2*pDp + 3/8*qDq )
 + B0(qDq,Mx,Mx)*Det^-2
  * ( 3/8*Mx^2*pDp*qDq - 3/8*My^2*pDp*qDq + 3/8*pDp^2*qDq )
 + B0(qDq,Mx,Mx)*Det^-1
  * ( - 1/4*Mx^2 + 1/4*My^2 - 1/2*pDp - 3/8*qDq )

Al,C22(Mx~,My~,Mx~) = i*Pi^2*Det^-1
  * ( - 1/4*pDp )
 + Det^-2*C0(Mx,My,Mx)
  * ( - 3/4*Mx^2*My^2*pDp*qDq + 3/4*Mx^2*pDp^2*qDq + 3/8*Mx^4*pDp*qDq
   - 3/4*My^2*pDp^2*qDq + 3/8*My^4*pDp*qDq + 3/8*pDp^3*qDq )
 + Det^-1*C0(Mx,My,Mx)
  * ( 1/2*Mx^2*My^2 - 1/2*Mx^2*pDp - 1/4*Mx^4 + My^2*pDp - 1/4*My^4
   - 1/4*pDp^2 )
 + Ax(Mx)*Det^-1
  * ( 1/4 - 1/8*pDp^-1*qDq )
 + Ax(My)*Det^-1
  * ( - 1/4 + 1/8*pDp^-1*qDq )
 + B0(pDp,Mx,My)*Det^-2
  * ( - 3/8*Mx^2*pDp*qDq + 3/8*My^2*pDp*qDq - 3/8*pDp^2*qDq )
 + B0(pDp,Mx,My)*Det^-1
  * ( 1/2*Mx^2 - 1/8*Mx^2*pDp^-1*qDq - 1/2*My^2 + 1/8*My^2*pDp^-1*qDq
   + 1/2*pDp - 1/8*qDq )
 + B0(qDq,Mx,Mx)*Det^-2
  * ( 3/8*Mx^2*pDp*qDq - 3/8*My^2*pDp*qDq + 3/8*pDp^2*qDq )
 + B0(qDq,Mx,Mx)*Det^-1
  * ( - 1/4*Mx^2 + 1/4*My^2 - 1/2*pDp + 1/8*qDq )

Al,C23(Mx~,My~,Mx~) = i*Pi^2*Det^-1
  * ( - 1/4*pDp + 1/8*qDq )
 + Det^-2*C0(Mx,My,Mx)
  * ( 3/4*Mx^2*My^2*pDp*qDq - 3/4*Mx^2*pDp^2*qDq - 3/8*Mx^4*pDp*qDq
   + 3/4*My^2*pDp^2*qDq - 3/8*My^4*pDp*qDq - 3/8*pDp^3*qDq )
 + Det^-1*C0(Mx,My,Mx)
  * ( - Mx^2*My^2 + Mx^2*pDp + 1/4*Mx^2*qDq + 1/2*Mx^4 - 1/2*My^2*pDp
   - 1/2*My^2*qDq + 1/2*My^4 + 1/4*pDp*qDq + 1/2*pDp^2 )
 + 1/4*Ax(Mx)*Det^-1
 - 1/4*Ax(My)*Det^-1
 + B0(pDp,Mx,My)*Det^-2
  * ( 3/8*Mx^2*pDp*qDq - 3/8*My^2*pDp*qDq + 3/8*pDp^2*qDq )
 + B0(pDp,Mx,My)*Det^-1
  * ( - 1/4*Mx^2 + 1/4*My^2 - 1/4*pDp - 1/4*qDq )
 + B0(qDq,Mx,Mx)*Det^-2
  * ( - 3/8*Mx^2*pDp*qDq + 3/8*My^2*pDp*qDq - 3/8*pDp^2*qDq )
 + B0(qDq,Mx,Mx)*Det^-1
  * ( 1/2*Mx^2 - 1/2*My^2 + 1/4*pDp + 1/4*qDq )

Id,C24(Mx~,My~,Mx~) = 1/4*i*Pi^2
 + Det^-1*C0(Mx,My,Mx)
  * ( 1/4*Mx^2*My^2*qDq - 1/4*Mx^2*pDp*qDq - 1/8*Mx^4*qDq
  + 1/4*My^2*pDp*qDq - 1/8*My^4*qDq - 1/8*pDp^2*qDq )
 + C0(Mx,My,Mx)
  * ( - 1/2*My^2 )
 + B0(pDp,Mx,My)*Det^-1
  * ( 1/8*Mx^2*qDq - 1/8*My^2*qDq + 1/8*pDp*qDq )
 + 1/4*B0(qDq,Mx,Mx)
 + B0(qDq,Mx,Mx)*Det^-1
  * ( - 1/8*Mx^2*qDq + 1/8*My^2*qDq - 1/8*pDp*qDq ) + 0.

Id,C31(Mx~,My~,Mx~) = i*Pi^2*Det^-2
  * ( - 5/48*Mx^2*pDp*qDq + 5/48*My^2*pDp*qDq - 5/48*pDp^2*qDq )
 + i*Pi^2*Det^-1
  * ( 1/6*Mx^2 - 1/24*Mx^2*pDp^-1*qDq + 1/12*My^2 - 1/24*My^2*pDp^-1
  *qDq + 2/3*pDp )
 + Det^-3*C0(Mx,My,Mx)
  * ( - 15/4*Mx^2*My^2*pDp^3*qDq + 15/8*Mx^2*My^4*pDp^2*qDq
  + 15/8*Mx^2*pDp^4*qDq - 15/8*Mx^4*My^2*pDp^2*qDq + 15/8*Mx^4*pDp^3
  *qDq + 5/8*Mx^6*pDp^2*qDq - 15/8*My^2*pDp^4*qDq + 15/8*My^4*pDp^3
  *qDq - 5/8*My^6*pDp^2*qDq + 5/8*pDp^5*qDq )
 + Det^-2*C0(Mx,My,Mx)
  * ( 3*Mx^2*My^2*pDp*qDq + 15/4*Mx^2*My^2*pDp^2 - 15/8*Mx^2*My^4*pDp
   - 3/16*Mx^2*My^4*qDq - 39/16*Mx^2*pDp^2*qDq - 15/8*Mx^2*pDp^3
  + 15/8*Mx^4*My^2*pDp + 3/16*Mx^4*My^2*qDq - 21/16*Mx^4*pDp*qDq
  - 15/8*Mx^4*pDp^2 - 5/8*Mx^6*pDp - 1/16*Mx^6*qDq + 45/16*My^2*pDp^2
  *qDq + 15/8*My^2*pDp^3 - 27/16*My^4*pDp*qDq - 15/8*My^4*pDp^2
  + 5/8*My^6*pDp + 1/16*My^6*qDq - 19/16*pDp^3*qDq - 5/8*pDp^4 )
 + Det^-1*C0(Mx,My,Mx)
  * ( - 3/2*Mx^2*My^2 + 3/2*Mx^2*pDp + 3/4*Mx^2*qDq + 3/4*Mx^4
  - 3*My^2*pDp - 3/4*My^2*qDq + 3/4*My^4 + 3/4*pDp*qDq + 3/4*pDp^2 )
 - C0(Mx,My,Mx)
 + Ax(Mx)*Det^-2
  * ( - 5/48*Mx^2*qDq + 5/48*My^2*qDq - 5/48*pDp*qDq )
 + Ax(Mx)*Det^-1
  * ( - 5/24 - 1/12*Mx^2*pDp^-2*qDq + 7/24*Mx^2*pDp^-1 + 1/12*My^2
  *pDp^-2*qDq - 7/24*My^2*pDp^-1 + 5/24*pDp^-1*qDq )
 + Ax(My)*Det^-2
  * ( 5/48*Mx^2*qDq - 5/48*My^2*qDq + 5/48*pDp*qDq )
 + Ax(My)*Det^-1
  * ( 11/24 + 1/12*Mx^2*pDp^-2*qDq - 7/24*Mx^2*pDp^-1 - 1/12*My^2*pDp^-2
  *qDq + 7/24*My^2*pDp^-1 - 7/24*pDp^-1*qDq )
 + B0(pDp,Mx,My)*Det^-3
  * ( 5/4*Mx^2*My^2*pDp^2*qDq - 5/4*Mx^2*pDp^3*qDq - 5/8*Mx^4*pDp^2
  *qDq + 5/4*My^2*pDp^3*qDq - 5/8*My^4*pDp^2*qDq - 5/8*pDp^4*qDq )
 + B0(pDp,Mx,My)*Det^-2
  * ( - 5/4*Mx^2*My^2*pDp + 1/12*Mx^2*My^2*qDq + 25/24*Mx^2*pDp*qDq
   + 5/4*Mx^2*pDp^2 + 5/8*Mx^4*pDp - 1/24*Mx^4*qDq - 29/24*My^2*pDp
  *qDq - 5/4*My^2*pDp^2 + 5/8*My^4*pDp - 1/24*My^4*qDq + 13/12*pDp^2
  *qDq + 5/8*pDp^3 )
 + B0(pDp,Mx,My)*Det^-1
  * ( - 11/12*Mx^2 + 1/6*Mx^2*My^2*pDp^-2*qDq - 7/12*Mx^2*My^2*pDp^-1
   + 5/24*Mx^2*pDp^-1*qDq - 1/12*Mx^4*pDp^-2*qDq + 7/24*Mx^4*pDp^-1
   + 13/12*My^2 - 7/24*My^2*pDp^-1*qDq - 1/12*My^4*pDp^-2*qDq
  + 7/24*My^4*pDp^-1 - 29/24*pDp - 11/24*qDq )
 + B0(qDq,Mx,Mx)*Det^-3
  * ( - 5/4*Mx^2*My^2*pDp^2*qDq + 5/4*Mx^2*pDp^3*qDq + 5/8*Mx^4*pDp^2
  *qDq - 5/4*My^2*pDp^3*qDq + 5/8*My^4*pDp^2*qDq + 5/8*pDp^4*qDq )
 + B0(qDq,Mx,Mx)*Det^-2
  * ( 5/4*Mx^2*My^2*pDp + 1/8*Mx^2*My^2*qDq - 55/48*Mx^2*pDp*qDq
  - 5/4*Mx^2*pDp^2 - 5/8*Mx^4*pDp - 1/16*Mx^4*qDq + 21/16*My^2*pDp
  *qDq + 5/4*My^2*pDp^2 - 5/8*My^4*pDp - 1/16*My^4*qDq - 13/12*pDp^2
  *qDq - 5/8*pDp^3 )
 + B0(qDq,Mx,Mx)*Det^-1
  * ( 17/24*Mx^2 - 5/8*My^2 + 29/24*pDp + 11/24*qDq )
 
Id,C32(Mx~,My~,Mx~) = i*Pi^2*Det^-2
  * ( 5/48*Mx^2*pDp*qDq - 5/48*My^2*pDp*qDq + 5/48*pDp^2*qDq )
 + i*Pi^2*Det^-1
  * ( - 1/6*Mx^2 + 1/24*Mx^2*pDp^-1*qDq - 1/12*My^2 + 1/24*My^2*pDp^-1
  *qDq + 1/12*pDp )
 + Det^-3*C0(Mx,My,Mx)
  * ( 15/4*Mx^2*My^2*pDp^3*qDq - 15/8*Mx^2*My^4*pDp^2*qDq
  - 15/8*Mx^2*pDp^4*qDq + 15/8*Mx^4*My^2*pDp^2*qDq - 15/8*Mx^4*pDp^3
  *qDq - 5/8*Mx^6*pDp^2*qDq + 15/8*My^2*pDp^4*qDq - 15/8*My^4*pDp^3
  *qDq + 5/8*My^6*pDp^2*qDq - 5/8*pDp^5*qDq )
 + Det^-2*C0(Mx,My,Mx)
  * ( - 3/4*Mx^2*My^2*pDp*qDq - 15/4*Mx^2*My^2*pDp^2 + 15/8*Mx^2*My^4
  *pDp + 3/16*Mx^2*My^4*qDq + 3/16*Mx^2*pDp^2*qDq + 15/8*Mx^2*pDp^3
   - 15/8*Mx^4*My^2*pDp - 3/16*Mx^4*My^2*qDq + 3/16*Mx^4*pDp*qDq
  + 15/8*Mx^4*pDp^2 + 5/8*Mx^6*pDp + 1/16*Mx^6*qDq - 9/16*My^2*pDp^2
  *qDq - 15/8*My^2*pDp^3 + 9/16*My^4*pDp*qDq + 15/8*My^4*pDp^2
  - 5/8*My^6*pDp - 1/16*My^6*qDq + 1/16*pDp^3*qDq + 5/8*pDp^4 )
 + Ax(Mx)*Det^-2
  * ( 5/48*Mx^2*qDq - 5/48*My^2*qDq + 5/48*pDp*qDq )
 + Ax(Mx)*Det^-1
  * ( - 13/24 + 1/12*Mx^2*pDp^-2*qDq - 7/24*Mx^2*pDp^-1 - 1/12*My^2
  *pDp^-2*qDq + 7/24*My^2*pDp^-1 + 1/6*pDp^-1*qDq )
 + Ax(My)*Det^-2
  * ( - 5/48*Mx^2*qDq + 5/48*My^2*qDq - 5/48*pDp*qDq )
 + Ax(My)*Det^-1
  * ( 7/24 - 1/12*Mx^2*pDp^-2*qDq + 7/24*Mx^2*pDp^-1 + 1/12*My^2*pDp^-2
  *qDq - 7/24*My^2*pDp^-1 - 1/12*pDp^-1*qDq )
 + B0(pDp,Mx,My)*Det^-3
  * ( - 5/4*Mx^2*My^2*pDp^2*qDq + 5/4*Mx^2*pDp^3*qDq + 5/8*Mx^4*pDp^2
  *qDq - 5/4*My^2*pDp^3*qDq + 5/8*My^4*pDp^2*qDq + 5/8*pDp^4*qDq )
 + B0(pDp,Mx,My)*Det^-2
  * ( 5/4*Mx^2*My^2*pDp - 1/12*Mx^2*My^2*qDq + 1/12*Mx^2*pDp*qDq
  - 5/4*Mx^2*pDp^2 - 5/8*Mx^4*pDp + 1/24*Mx^4*qDq + 1/12*My^2*pDp*qDq
   + 5/4*My^2*pDp^2 - 5/8*My^4*pDp + 1/24*My^4*qDq + 1/24*pDp^2*qDq
   - 5/8*pDp^3 )
 + B0(pDp,Mx,My)*Det^-1
  * ( - 7/12*Mx^2 - 1/6*Mx^2*My^2*pDp^-2*qDq + 7/12*Mx^2*My^2*pDp^-1
   + 1/6*Mx^2*pDp^-1*qDq + 1/12*Mx^4*pDp^-2*qDq - 7/24*Mx^4*pDp^-1
   + 5/12*My^2 - 1/12*My^2*pDp^-1*qDq + 1/12*My^4*pDp^-2*qDq
  - 7/24*My^4*pDp^-1 - 7/24*pDp + 1/12*qDq )
 + B0(qDq,Mx,Mx)*Det^-3
  * ( 5/4*Mx^2*My^2*pDp^2*qDq - 5/4*Mx^2*pDp^3*qDq - 5/8*Mx^4*pDp^2
  *qDq + 5/4*My^2*pDp^3*qDq - 5/8*My^4*pDp^2*qDq - 5/8*pDp^4*qDq )
 + B0(qDq,Mx,Mx)*Det^-2
  * ( - 5/4*Mx^2*My^2*pDp - 1/8*Mx^2*My^2*qDq + 1/48*Mx^2*pDp*qDq
  + 5/4*Mx^2*pDp^2 + 5/8*Mx^4*pDp + 1/16*Mx^4*qDq - 3/16*My^2*pDp*qDq
   - 5/4*My^2*pDp^2 + 5/8*My^4*pDp + 1/16*My^4*qDq - 1/24*pDp^2*qDq
   + 5/8*pDp^3 )
 + B0(qDq,Mx,Mx)*Det^-1
  * ( 1/24*Mx^2 - 1/8*My^2 + 7/24*pDp - 1/12*qDq )

Id,C33(Mx~,My~,Mx~) = i*Pi^2*Det^-2
  * ( 5/48*Mx^2*pDp*qDq - 5/48*My^2*pDp*qDq + 5/48*pDp^2*qDq )
 + i*Pi^2*Det^-1
  * ( - 1/12*Mx^2 + 1/6*My^2 + 1/3*pDp - 5/24*qDq )
 + Det^-3*C0(Mx,My,Mx)
  * ( 15/4*Mx^2*My^2*pDp^3*qDq - 15/8*Mx^2*My^4*pDp^2*qDq
  - 15/8*Mx^2*pDp^4*qDq + 15/8*Mx^4*My^2*pDp^2*qDq - 15/8*Mx^4*pDp^3
  *qDq - 5/8*Mx^6*pDp^2*qDq + 15/8*My^2*pDp^4*qDq - 15/8*My^4*pDp^3
  *qDq + 5/8*My^6*pDp^2*qDq - 5/8*pDp^5*qDq )
 + Det^-2*C0(Mx,My,Mx)
  * ( - 3*Mx^2*My^2*pDp*qDq - 15/4*Mx^2*My^2*pDp^2 + 15/8*Mx^2*My^4
  *pDp + 9/16*Mx^2*My^4*qDq + 33/16*Mx^2*pDp^2*qDq + 15/8*Mx^2*pDp^3
   - 15/8*Mx^4*My^2*pDp - 9/16*Mx^4*My^2*qDq + 21/16*Mx^4*pDp*qDq
  + 15/8*Mx^4*pDp^2 + 5/8*Mx^6*pDp + 3/16*Mx^6*qDq - 39/16*My^2*pDp^2
  *qDq - 15/8*My^2*pDp^3 + 27/16*My^4*pDp*qDq + 15/8*My^4*pDp^2
  - 5/8*My^6*pDp - 3/16*My^6*qDq + 15/16*pDp^3*qDq + 5/8*pDp^4 )
 + Det^-1*C0(Mx,My,Mx)
  * ( 5/2*Mx^2*My^2 - 2*Mx^2*pDp - 1/4*Mx^2*qDq - Mx^4 + 3/2*My^2*pDp
   + 3/4*My^2*qDq - 3/2*My^4 - 1/4*pDp*qDq - pDp^2 )
 + Ax(Mx)*Det^-2
  * ( 5/48*Mx^2*qDq - 5/48*My^2*qDq + 5/48*pDp*qDq )
 + Ax(Mx)*Det^-1
  * ( - 11/24 - 1/24*Mx^2*pDp^-1 + 1/24*My^2*pDp^-1 )
 + Ax(My)*Det^-2
  * ( - 5/48*Mx^2*qDq + 5/48*My^2*qDq - 5/48*pDp*qDq )
 + Ax(My)*Det^-1
  * ( 13/24 + 1/24*Mx^2*pDp^-1 - 1/24*My^2*pDp^-1 )
 + B0(pDp,Mx,My)*Det^-3
  * ( - 5/4*Mx^2*My^2*pDp^2*qDq + 5/4*Mx^2*pDp^3*qDq + 5/8*Mx^4*pDp^2
  *qDq - 5/4*My^2*pDp^3*qDq + 5/8*My^4*pDp^2*qDq + 5/8*pDp^4*qDq )
 + B0(pDp,Mx,My)*Det^-2
  * ( 5/4*Mx^2*My^2*pDp + 1/6*Mx^2*My^2*qDq - 11/12*Mx^2*pDp*qDq
  - 5/4*Mx^2*pDp^2 - 5/8*Mx^4*pDp - 1/12*Mx^4*qDq + 13/12*My^2*pDp
  *qDq + 5/4*My^2*pDp^2 - 5/8*My^4*pDp - 1/12*My^4*qDq - 5/6*pDp^2
  *qDq - 5/8*pDp^3 )
 + B0(pDp,Mx,My)*Det^-1
  * ( 5/12*Mx^2 + 1/12*Mx^2*My^2*pDp^-1 - 1/24*Mx^4*pDp^-1
  - 7/12*My^2 - 1/24*My^4*pDp^-1 + 11/24*pDp + 1/4*qDq )
 + B0(qDq,Mx,Mx)*Det^-3
  * ( 5/4*Mx^2*My^2*pDp^2*qDq - 5/4*Mx^2*pDp^3*qDq - 5/8*Mx^4*pDp^2
  *qDq + 5/4*My^2*pDp^3*qDq - 5/8*My^4*pDp^2*qDq - 5/8*pDp^4*qDq )
 + B0(qDq,Mx,Mx)*Det^-2
  * ( - 5/4*Mx^2*My^2*pDp - 3/8*Mx^2*My^2*qDq + 49/48*Mx^2*pDp*qDq
   + 5/4*Mx^2*pDp^2 + 5/8*Mx^4*pDp + 3/16*Mx^4*qDq - 19/16*My^2*pDp
  *qDq - 5/4*My^2*pDp^2 + 5/8*My^4*pDp + 3/16*My^4*qDq + 5/6*pDp^2
  *qDq + 5/8*pDp^3 )
 + B0(qDq,Mx,Mx)*Det^-1
  * ( - 7/8*Mx^2 + 9/8*My^2 - 11/24*pDp - 1/4*qDq )

Id,C34(Mx~,My~,Mx~) = i*Pi^2*Det^-2
  * ( - 5/48*Mx^2*pDp*qDq + 5/48*My^2*pDp*qDq - 5/48*pDp^2*qDq )
 + i*Pi^2*Det^-1
  * ( 1/12*Mx^2 - 1/6*My^2 + 5/12*pDp - 1/24*qDq )
 + Det^-3*C0(Mx,My,Mx)
  * ( - 15/4*Mx^2*My^2*pDp^3*qDq + 15/8*Mx^2*My^4*pDp^2*qDq
  + 15/8*Mx^2*pDp^4*qDq - 15/8*Mx^4*My^2*pDp^2*qDq + 15/8*Mx^4*pDp^3
  *qDq + 5/8*Mx^6*pDp^2*qDq - 15/8*My^2*pDp^4*qDq + 15/8*My^4*pDp^3
  *qDq - 5/8*My^6*pDp^2*qDq + 5/8*pDp^5*qDq )
 + Det^-2*C0(Mx,My,Mx)
  * ( 9/4*Mx^2*My^2*pDp*qDq + 15/4*Mx^2*My^2*pDp^2 - 15/8*Mx^2*My^4
  *pDp - 9/16*Mx^2*My^4*qDq - 21/16*Mx^2*pDp^2*qDq - 15/8*Mx^2*pDp^3
   + 15/8*Mx^4*My^2*pDp + 9/16*Mx^4*My^2*qDq - 15/16*Mx^4*pDp*qDq
  - 15/8*Mx^4*pDp^2 - 5/8*Mx^6*pDp - 3/16*Mx^6*qDq + 27/16*My^2*pDp^2
  *qDq + 15/8*My^2*pDp^3 - 21/16*My^4*pDp*qDq - 15/8*My^4*pDp^2
  + 5/8*My^6*pDp + 3/16*My^6*qDq - 9/16*pDp^3*qDq - 5/8*pDp^4 )
 + Det^-1*C0(Mx,My,Mx)
  * ( - Mx^2*My^2 + 1/2*Mx^2*pDp + 1/4*Mx^4 - 3/2*My^2*pDp
  + 3/4*My^4 + 1/4*pDp^2 )
 + Ax(Mx)*Det^-2
  * ( - 5/48*Mx^2*qDq + 5/48*My^2*qDq - 5/48*pDp*qDq )
 + Ax(Mx)*Det^-1
  * ( - 7/24 + 1/24*Mx^2*pDp^-1 - 1/24*My^2*pDp^-1 + 1/8*pDp^-1*qDq )
 + Ax(My)*Det^-2
  * ( 5/48*Mx^2*qDq - 5/48*My^2*qDq + 5/48*pDp*qDq )
 + Ax(My)*Det^-1
  * ( 5/24 - 1/24*Mx^2*pDp^-1 + 1/24*My^2*pDp^-1 - 1/8*pDp^-1*qDq )
 + B0(pDp,Mx,My)*Det^-3
  * ( 5/4*Mx^2*My^2*pDp^2*qDq - 5/4*Mx^2*pDp^3*qDq - 5/8*Mx^4*pDp^2
  *qDq + 5/4*My^2*pDp^3*qDq - 5/8*My^4*pDp^2*qDq - 5/8*pDp^4*qDq )
 + B0(pDp,Mx,My)*Det^-2
  * ( - 5/4*Mx^2*My^2*pDp - 1/6*Mx^2*My^2*qDq + 13/24*Mx^2*pDp*qDq
   + 5/4*Mx^2*pDp^2 + 5/8*Mx^4*pDp + 1/12*Mx^4*qDq - 17/24*My^2*pDp
  *qDq - 5/4*My^2*pDp^2 + 5/8*My^4*pDp + 1/12*My^4*qDq + 11/24*pDp^2
  *qDq + 5/8*pDp^3 )
 + B0(pDp,Mx,My)*Det^-1
  * ( - 5/12*Mx^2 - 1/12*Mx^2*My^2*pDp^-1 + 1/8*Mx^2*pDp^-1*qDq
  + 1/24*Mx^4*pDp^-1 + 7/12*My^2 - 1/8*My^2*pDp^-1*qDq + 1/24*My^4
  *pDp^-1 - 11/24*pDp + 1/8*qDq )
 + B0(qDq,Mx,Mx)*Det^-3
  * ( - 5/4*Mx^2*My^2*pDp^2*qDq + 5/4*Mx^2*pDp^3*qDq + 5/8*Mx^4*pDp^2
  *qDq - 5/4*My^2*pDp^3*qDq + 5/8*My^4*pDp^2*qDq + 5/8*pDp^4*qDq )
 + B0(qDq,Mx,Mx)*Det^-2
  * ( 5/4*Mx^2*My^2*pDp + 3/8*Mx^2*My^2*qDq - 31/48*Mx^2*pDp*qDq
  - 5/4*Mx^2*pDp^2 - 5/8*Mx^4*pDp - 3/16*Mx^4*qDq + 13/16*My^2*pDp
  *qDq + 5/4*My^2*pDp^2 - 5/8*My^4*pDp - 3/16*My^4*qDq - 11/24*pDp^2
  *qDq - 5/8*pDp^3 )
 + B0(qDq,Mx,Mx)*Det^-1
  * ( 1/8*Mx^2 - 3/8*My^2 + 11/24*pDp - 1/8*qDq )
 
Id,C35(Mx~,My~,Mx~) = - 7/36*i*Pi^2
 + i*Pi^2*Det^-1
  * ( 1/48*Mx^2*qDq - 1/48*My^2*qDq + 1/48*pDp*qDq )
 + Det^-2*C0(Mx,My,Mx)
  * ( 3/4*Mx^2*My^2*pDp^2*qDq - 3/8*Mx^2*My^4*pDp*qDq - 3/8*Mx^2*pDp^3
  *qDq + 3/8*Mx^4*My^2*pDp*qDq - 3/8*Mx^4*pDp^2*qDq - 1/8*Mx^6*pDp
  *qDq + 3/8*My^2*pDp^3*qDq - 3/8*My^4*pDp^2*qDq + 1/8*My^6*pDp*qDq
   - 1/8*pDp^4*qDq )
 + Det^-1*C0(Mx,My,Mx)
  * ( - 3/4*Mx^2*My^2*pDp - 3/8*Mx^2*My^2*qDq + 3/8*Mx^2*My^4
  + 1/4*Mx^2*pDp*qDq + 3/8*Mx^2*pDp^2 - 3/8*Mx^4*My^2 + 3/8*Mx^4*pDp
   + 1/8*Mx^4*qDq + 1/8*Mx^6 - 3/8*My^2*pDp*qDq - 3/8*My^2*pDp^2
  + 3/8*My^4*pDp + 1/4*My^4*qDq - 1/8*My^6 + 1/8*pDp^2*qDq
  + 1/8*pDp^3 )
 + C0(Mx,My,Mx)
  * ( 1/2*My^2 )
 + Ax(Mx)*Det^-1
  * ( 1/48*Mx^2*pDp^-1*qDq - 1/48*My^2*pDp^-1*qDq + 1/48*qDq )
 + Ax(My)*Det^-1
  * ( - 1/48*Mx^2*pDp^-1*qDq + 1/48*My^2*pDp^-1*qDq - 1/48*qDq )
 + B0(pDp,Mx,My)*Det^-2
  * ( - 1/4*Mx^2*My^2*pDp*qDq + 1/4*Mx^2*pDp^2*qDq + 1/8*Mx^4*pDp*qDq
   - 1/4*My^2*pDp^2*qDq + 1/8*My^4*pDp*qDq + 1/8*pDp^3*qDq )
 + B0(pDp,Mx,My)*Det^-1
  * ( 1/4*Mx^2*My^2 - 1/24*Mx^2*My^2*pDp^-1*qDq - 1/4*Mx^2*pDp
  - 1/12*Mx^2*qDq - 1/8*Mx^4 + 1/48*Mx^4*pDp^-1*qDq + 1/4*My^2*pDp
   + 1/6*My^2*qDq - 1/8*My^4 + 1/48*My^4*pDp^-1*qDq - 5/48*pDp*qDq
   - 1/8*pDp^2 )
 - 1/6*B0(qDq,Mx,Mx)
 + B0(qDq,Mx,Mx)*Det^-2
  * ( 1/4*Mx^2*My^2*pDp*qDq - 1/4*Mx^2*pDp^2*qDq - 1/8*Mx^4*pDp*qDq
   + 1/4*My^2*pDp^2*qDq - 1/8*My^4*pDp*qDq - 1/8*pDp^3*qDq )
 + B0(qDq,Mx,Mx)*Det^-1
  * ( - 1/4*Mx^2*My^2 + 1/4*Mx^2*pDp + 5/48*Mx^2*qDq + 1/8*Mx^4
  - 1/4*My^2*pDp - 3/16*My^2*qDq + 1/8*My^4 + 5/48*pDp*qDq
  + 1/8*pDp^2 )

Id,C36(Mx~,My~,Mx~) = - 1/18*i*Pi^2
 + i*Pi^2*Det^-1
  * ( - 1/48*Mx^2*qDq + 1/48*My^2*qDq - 1/48*pDp*qDq )
 + Det^-2*C0(Mx,My,Mx)
  * ( - 3/4*Mx^2*My^2*pDp^2*qDq + 3/8*Mx^2*My^4*pDp*qDq + 3/8*Mx^2
  *pDp^3*qDq - 3/8*Mx^4*My^2*pDp*qDq + 3/8*Mx^4*pDp^2*qDq
  + 1/8*Mx^6*pDp*qDq - 3/8*My^2*pDp^3*qDq + 3/8*My^4*pDp^2*qDq
  - 1/8*My^6*pDp*qDq + 1/8*pDp^4*qDq )
 + Det^-1*C0(Mx,My,Mx)
  * ( 3/4*Mx^2*My^2*pDp + 1/8*Mx^2*My^2*qDq - 3/8*Mx^2*My^4
  - 3/8*Mx^2*pDp^2 + 3/8*Mx^4*My^2 - 3/8*Mx^4*pDp - 1/8*Mx^6
  + 1/8*My^2*pDp*qDq + 3/8*My^2*pDp^2 - 3/8*My^4*pDp - 1/8*My^4*qDq
   + 1/8*My^6 - 1/8*pDp^3 )
 + Ax(Mx)*Det^-1
  * ( - 1/48*Mx^2*pDp^-1*qDq + 1/48*My^2*pDp^-1*qDq - 1/48*qDq )
 + Ax(My)*Det^-1
  * ( 1/48*Mx^2*pDp^-1*qDq - 1/48*My^2*pDp^-1*qDq + 1/48*qDq )
 + B0(pDp,Mx,My)*Det^-2
  * ( 1/4*Mx^2*My^2*pDp*qDq - 1/4*Mx^2*pDp^2*qDq - 1/8*Mx^4*pDp*qDq
   + 1/4*My^2*pDp^2*qDq - 1/8*My^4*pDp*qDq - 1/8*pDp^3*qDq )
 + B0(pDp,Mx,My)*Det^-1
  * ( - 1/4*Mx^2*My^2 + 1/24*Mx^2*My^2*pDp^-1*qDq + 1/4*Mx^2*pDp
  - 1/24*Mx^2*qDq + 1/8*Mx^4 - 1/48*Mx^4*pDp^-1*qDq - 1/4*My^2*pDp
   - 1/24*My^2*qDq + 1/8*My^4 - 1/48*My^4*pDp^-1*qDq - 1/48*pDp*qDq
   + 1/8*pDp^2 )
 - 1/12*B0(qDq,Mx,Mx)
 + B0(qDq,Mx,Mx)*Det^-2
  * ( - 1/4*Mx^2*My^2*pDp*qDq + 1/4*Mx^2*pDp^2*qDq + 1/8*Mx^4*pDp*qDq
   - 1/4*My^2*pDp^2*qDq + 1/8*My^4*pDp*qDq + 1/8*pDp^3*qDq )
 + B0(qDq,Mx,Mx)*Det^-1
  * ( 1/4*Mx^2*My^2 - 1/4*Mx^2*pDp + 1/48*Mx^2*qDq - 1/8*Mx^4
  + 1/4*My^2*pDp + 1/16*My^2*qDq - 1/8*My^4 + 1/48*pDp*qDq
  - 1/8*pDp^2 )

Id,N=N_+4
Al,[1-N]^-1=-1/3 + N_/9
Id,N_*Ax(m~) = 2*i*Pi^2*m^2
Al,N_*B0(u~,m~,M~) = - 2*i*Pi^2
Id,N_=0
Id,N=4
Id,Symme,B0,2,3
Id,Ax(m~)=Axf(m)*m^2
KINE{}
CASE{}
*yep
Id,Det^n~=(-1)^n*s^n*r^(2*n)
C Id,Multi,r^4=s^2/16 - s*M^2/2 + M^4
 Id,Multi,r^2=s/4-M^2

 IF Multi,s^-1
 AND Multi,r^-2=4*fr2^-1
 Id,Ratio,fr2,s,fM2
 Id,fr2^n~=4^n*r^(2*n)
 Al,fM2^n~=4^n*M^(2*n)
 ENDIF

 IF s
 AND Multi,r^-2
 Id,s=4*r^2-4*M^2
 ENDIF
*yep
Id,Axf(m~)= 2*i*Pi^2/N_ + i*Pi^2*(-1+Log(m))
Al,B0(u~,m~,M~) = - 2*i*Pi^2/N_ + B0f(u,m,M)
Id,Count,x,r,1,s,2,M,1,M0,1,Mu,1,E,1,C0,-2
IF x=1
Id,Addfa,Error
ENDIF
B Error,g0,Alw,i,Pi,N_
P output
*yep
Id,DEL=-2*i*Pi^2/N_
Id,r= E/2 - Mx^2/E/2 - My^2/E/2
C - Mx^2*My^2/E^3
Al,Multi,r^-1 = 2/E + 2*Mx^2/E^3 + 2*My^2/E^3
C + 2*(4*Mx^2*My^2+Mx^4+My^4)/E^5
Al,d1=2*Mx^2/E^2
C + 2*Mx^2*My^2/E^4
Al,d2=2*My^2/E^2
C + 2*Mx^2*My^2/E^4
CASE{}
Al,s=E^2
Al,Multi,s^-1=E^-2
Id,Count,2,r,1,s,2,Mu,1,E,1,C0,-2,N_,-10,g0,10,Error,10
P output
*yep
C Limit of high energy, and also large Mu mass.
  Notations: Log2 = Log^2, eps=Mu^2/s and del=M^2/Mu^2

Id,C0(Mu,0,Mu)=-i*Pi^2/s*(- Pi^2/6 + 1/2*Log2(eps)-eps*Log(eps)+eps)
Al,C0(0,Mu,0)=-i*Pi^2/s*(- Pi^2 + Log2(eps) + 4*eps*Log(eps))
Al,B0f(qDq,0,0)=2*i*Pi^2 - i*Pi^2*Log(s)
Al,B0f(pDp,Mu,0)=i*Pi^2 *(1-Log(Mu)+del/2-del^2/6)
Al,B0f(qDq,Mu,Mu)=
 i*Pi^2*(2-Log(s)-2*eps*Log(eps)+2*eps-2*eps^2*Log(eps)-eps^2)
Al,B0f(pDp,Me,0)=2*i*Pi^2 - i*Pi^2*Log(M)
Al,B0f(qDq,Me,Me)=2*i*Pi^2 - i*Pi^2*Log(s)
Id,eps=Mu^2/s
Al,del=M^2/Mu^2
Id,s^n~=E^(2*n)
Al,Log(s)=Log(Mu)-Log(eps)
Id,Count,2,s,2,Mu,1,E,1,N_,-10,g0,10,Error,10
IF NOT g0
Id,Addfa,Alw*4*Pi
ENDIF
C Make coefficient of zeroeth order one.
Id,Addfa,i/16/Pi^4*M^2/E^2
IF Multi,E^-3
Id,Addfa,0
ENDIF
*end
C e+e- => WW. 6. Approximation for large equal masses of selfenerg correction.
  Uses common file Self.

P ninput

Read Standb.e
NAMES{}
Enter Self
*fix

Z IZZ=IWW(mu,nu)

*yep
B Wave,i,Pi,N_
Id,q(al~)*q(be~)=Wave*q(al)*q(be) + qDq*D(al,be)
Id,qDq^n~=(-1)^n*E^(2*n)

Id,Md=Mx
Al,Me=Mx
Al,Mn=Mx
Al,Mu=Mx

Id,Ax(M~) = 2*i*Pi^2*M^2/N_ + i*Pi^2*M^2*(-1+Log(M))

Id,Log(Mu)=Log(Mx)
Al,Log(Md)=Log(Mx)
Al,Log(Mn)=Log(Mx)
Al,Log(Me)=Log(Mx)

Id,B0f(u~,Me,m~)=B0f(u,Mx,m)
Al,B0f(u~,Mn,m~)=B0f(u,Mx,m)
Al,B0f(u~,Md,m~)=B0f(u,Mx,m)
Al,B0f(u~,Mu,m~)=B0f(u,Mx,m)
Id,B0f(u~,m~,Me)=B0f(u,m,Mx)
Al,B0f(u~,m~,Mn)=B0f(u,m,Mx)
Al,B0f(u~,m~,Md)=B0f(u,m,Mx)
Al,B0f(u~,m~,Mu)=B0f(u,m,Mx)
*yep
Id,B0f(m~,Mx,Mx)= - i*Pi^2*Log(Mx)
Id,s^n~=E^(2*n)
Al,Log(s)=Log(Mx)-Log(eps)

*end

C e+e- => WW. 7. Approximation for large equal masses of WWW vertex correction.
  Uses common file Vertex.
P ninput

Read Standb.e
NAMES{}
Enter Vertex
*fix

BLOCK KINE{}
Id,Epf(al~,be~,ga~,de~)=0
Al,Me=0
Al,Md=0
Al,Mn=0
Id,pDep=0
Al,kDek=0
Al,qDep=-E*r/M
Al,kDep=E*r/M
Al,qDek=-E*r/M
Al,pDek=E*r/M
Al,epDek=-s/M^2/2+1
Id,r^2=s/4-M^2
Al,pDk=-s/2+M^2
Al,qDq^n~=(-1)^n*s^n
Al,qDp=s/2
Al,qDk=s/2
Al,pDp^n~=(-1)^n*M^(2*n)
Al,kDk^n~=(-1)^n*M^(2*n)
Al,Multi,E^2=s
ENDBLOCK

BLOCK CASE{}
Id,Mx^n~=M^n
Al,My^n~=M^n
Al,d2=d1
Al,B0(kDk,m~,M~)=B0(pDp,m,M)
ENDBLOCK

Z IZWWMx = IWWpWm(mu)

*yep
Id,C0~(Mu,M~,m~)=C0(Mx,M,m)
Al,C0~(Md,M~,m~)=C0(Mx,M,m)
Al,C0~(Mn,M~,m~)=C0(Mx,M,m)
Al,C0~(Me,M~,m~)=C0(Mx,M,m)
Id,C0~(M~,Mu,m~)=C0(M,Mx,m)
Al,C0~(M~,Md,m~)=C0(M,Mx,m)
Al,C0~(M~,Mn,m~)=C0(M,Mx,m)
Al,C0~(M~,Me,m~)=C0(M,Mx,m)
Id,C0~(M~,m~,Mu)=C0(M,m,Mx)
Al,C0~(M~,m~,Md)=C0(M,m,Mx)
Al,C0~(M~,m~,Mn)=C0(M,m,Mx)
Al,C0~(M~,m~,Me)=C0(M,m,Mx)

*yep

Id,C11(M1~,M2~,M3~) = 
 + B0(pDp,M1,M1)*Det^-1
  * ( - 1/4*pDp - 1/2*pDk - 1/4*kDk )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( 1/4*pDp + 1/2*pDk + 1/4*kDk )
 
 - C0(M1,M2,M3)
 
 + C0(M1,M2,M3)*Det^-1
  * ( 1/2*pDp*pDk + 1/4*pDp*kDk + 1/4*pDp^2 )
 
Id,C12(M1~,M2~,M3~) = 
 + B0(pDp,M1,M1)*Det^-1
  * ( 1/4*pDp + 1/2*pDk + 1/4*kDk )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( - 1/4*pDp - 1/2*pDk - 1/4*kDk )
 
 + C0(M1,M2,M3)*Det^-1
  * ( - 1/2*pDp*pDk - 1/4*pDp*kDk - 1/4*pDp^2 )
 
Id,C21(M1~,M2~,M3~) = 
 + i*Pi^2*Det^-1
  * ( - 1/4*pDp )
 
 + B0(pDp,M1,M1)*Det^-2
  * ( - 3/4*pDp^2*pDk - 3/8*pDp^2*kDk - 3/8*pDp^3 )
 
 + B0(pDp,M1,M1)*Det^-1
  * ( 7/8*pDp + 3/4*pDk + 3/8*kDk )
 
 + B0(qDq,M1,M1)*Det^-2
  * ( 3/4*pDp^2*pDk + 3/8*pDp^2*kDk + 3/8*pDp^3 )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( - 7/8*pDp - 3/4*pDk - 3/8*kDk )
 
 + C0(M1,M2,M3)
 
 + C0(M1,M2,M3)*Det^-2
  * ( 3/4*pDp^3*pDk + 3/8*pDp^3*kDk + 3/8*pDp^4 )
 
 + C0(M1,M2,M3)*Det^-1
  * ( 1/2*M1^2*pDp - pDp*pDk - 1/2*pDp*kDk - 3/4*pDp^2 )
 
Id,C22(M1~,M2~,M3~) = 
 + i*Pi^2*Det^-1
  * ( - 1/4*pDp )
 
 + B0(pDp,M1,M1)*Det^-2
  * ( - 3/4*pDp^2*pDk - 3/8*pDp^2*kDk - 3/8*pDp^3 )
 
 + B0(pDp,M1,M1)*Det^-1
  * ( 3/8*pDp - 1/4*pDk - 1/8*kDk )
 
 + B0(qDq,M1,M1)*Det^-2
  * ( 3/4*pDp^2*pDk + 3/8*pDp^2*kDk + 3/8*pDp^3 )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( - 3/8*pDp + 1/4*pDk + 1/8*kDk )
 
 + C0(M1,M2,M3)*Det^-2
  * ( 3/4*pDp^3*pDk + 3/8*pDp^3*kDk + 3/8*pDp^4 )
 
 + C0(M1,M2,M3)*Det^-1
  * ( 1/2*M1^2*pDp - 1/4*pDp^2 )
 
Id,C23(M1~,M2~,M3~) = 
 + i*Pi^2*Det^-1
  * ( - 1/8*pDp + 1/4*pDk + 1/8*kDk )
 
 + B0(pDp,M1,M1)*Det^-2
  * ( 3/4*pDp^2*pDk + 3/8*pDp^2*kDk + 3/8*pDp^3 )
 
 + B0(pDp,M1,M1)*Det^-1
  * ( - 1/2*pDp - 1/2*pDk - 1/4*kDk )
 
 + B0(qDq,M1,M1)*Det^-2
  * ( - 3/4*pDp^2*pDk - 3/8*pDp^2*kDk - 3/8*pDp^3 )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( 1/2*pDp + 1/2*pDk + 1/4*kDk )
 
 + C0(M1,M2,M3)*Det^-2
  * ( - 3/4*pDp^3*pDk - 3/8*pDp^3*kDk - 3/8*pDp^4 )
 
 + C0(M1,M2,M3)*Det^-1
  * ( 1/4*M1^2*pDp - 1/2*M1^2*pDk - 1/4*M1^2*kDk + 1/2*pDp*pDk
  + 1/4*pDp*kDk + 3/4*pDp^2 )
 
Id,C24(M1~,M2~,M3~) = 
 + 1/4*i*Pi^2
 
 + B0(pDp,M1,M1)*Det^-1
  * ( 1/4*pDp*pDk + 1/8*pDp*kDk + 1/8*pDp^2 )
 
 + 1/4*B0(qDq,M1,M1)
 
 + B0(qDq,M1,M1)*Det^-1
  * ( - 1/4*pDp*pDk - 1/8*pDp*kDk - 1/8*pDp^2 )
 
 + C0(M1,M2,M3)
  * ( - 1/2*M1^2 )
 
 + C0(M1,M2,M3)*Det^-1
  * ( - 1/4*pDp^2*pDk - 1/8*pDp^2*kDk - 1/8*pDp^3 )
 
Id,C31(M1~,M2~,M3~) = 
 + i*Pi^2*Det^-2
  * ( - 5/24*pDp^2*pDk - 5/48*pDp^2*kDk - 5/48*pDp^3 )
 
 + i*Pi^2*Det^-1
  * ( 1/6*M1^2 - 1/6*M1^2*pDp^-1*pDk - 1/12*M1^2*pDp^-1*kDk
  + 2/3*pDp )
 
 + Ax(M1)*Det^-1
  * ( 1/6 - 1/6*pDp^-1*pDk - 1/12*pDp^-1*kDk )
 
 + B0(pDp,M1,M1)*Det^-3
  * ( - 5/4*pDp^4*pDk - 5/8*pDp^4*kDk - 5/8*pDp^5 )
 
 + B0(pDp,M1,M1)*Det^-2
  * ( - 1/3*M1^2*pDp*pDk - 1/6*M1^2*pDp*kDk - 1/6*M1^2*pDp^2
  + 13/6*pDp^2*pDk + 13/12*pDp^2*kDk + 41/24*pDp^3 )
 
 + B0(pDp,M1,M1)*Det^-1
  * ( 1/12*M1^2 - 1/6*M1^2*pDp^-1*pDk - 1/12*M1^2*pDp^-1*kDk
  - 5/3*pDp - 11/12*pDk - 11/24*kDk )
 
 + B0(qDq,M1,M1)*Det^-3
  * ( 5/4*pDp^4*pDk + 5/8*pDp^4*kDk + 5/8*pDp^5 )
 
 + B0(qDq,M1,M1)*Det^-2
  * ( 1/3*M1^2*pDp*pDk + 1/6*M1^2*pDp*kDk + 1/6*M1^2*pDp^2
  - 13/6*pDp^2*pDk - 13/12*pDp^2*kDk - 41/24*pDp^3 )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( 1/12*M1^2 + 5/3*pDp + 11/12*pDk + 11/24*kDk )
 
 - C0(M1,M2,M3)
 
 + C0(M1,M2,M3)*Det^-3
  * ( 5/4*pDp^5*pDk + 5/8*pDp^5*kDk + 5/8*pDp^6 )
 
 + C0(M1,M2,M3)*Det^-2
  * ( 3/4*M1^2*pDp^2*pDk + 3/8*M1^2*pDp^2*kDk + 3/8*M1^2*pDp^3
  - 19/8*pDp^3*pDk - 19/16*pDp^3*kDk - 29/16*pDp^4 )
 
 + C0(M1,M2,M3)*Det^-1
  * ( - 3/2*M1^2*pDp + 3/2*pDp*pDk + 3/4*pDp*kDk + 3/2*pDp^2 )
 
Id,C32(M1~,M2~,M3~) = 
 + i*Pi^2*Det^-2
  * ( 5/24*pDp^2*pDk + 5/48*pDp^2*kDk + 5/48*pDp^3 )
 
 + i*Pi^2*Det^-1
  * ( - 1/6*M1^2 + 1/6*M1^2*pDp^-1*pDk + 1/12*M1^2*pDp^-1*kDk
  + 1/12*pDp )
 
 + Ax(M1)*Det^-1
  * ( - 1/6 + 1/6*pDp^-1*pDk + 1/12*pDp^-1*kDk )
 
 + B0(pDp,M1,M1)*Det^-3
  * ( 5/4*pDp^4*pDk + 5/8*pDp^4*kDk + 5/8*pDp^5 )
 
 + B0(pDp,M1,M1)*Det^-2
  * ( 1/3*M1^2*pDp*pDk + 1/6*M1^2*pDp*kDk + 1/6*M1^2*pDp^2
  + 1/12*pDp^2*pDk + 1/24*pDp^2*kDk - 7/12*pDp^3 )
 
 + B0(pDp,M1,M1)*Det^-1
  * ( - 1/12*M1^2 + 1/6*M1^2*pDp^-1*pDk + 1/12*M1^2*pDp^-1*kDk
  - 5/24*pDp + 1/6*pDk + 1/12*kDk )
 
 + B0(qDq,M1,M1)*Det^-3
  * ( - 5/4*pDp^4*pDk - 5/8*pDp^4*kDk - 5/8*pDp^5 )
 
 + B0(qDq,M1,M1)*Det^-2
  * ( - 1/3*M1^2*pDp*pDk - 1/6*M1^2*pDp*kDk - 1/6*M1^2*pDp^2
  - 1/12*pDp^2*pDk - 1/24*pDp^2*kDk + 7/12*pDp^3 )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( - 1/12*M1^2 + 5/24*pDp - 1/6*pDk - 1/12*kDk )
 
 + C0(M1,M2,M3)*Det^-3
  * ( - 5/4*pDp^5*pDk - 5/8*pDp^5*kDk - 5/8*pDp^6 )
 
 + C0(M1,M2,M3)*Det^-2
  * ( - 3/4*M1^2*pDp^2*pDk - 3/8*M1^2*pDp^2*kDk - 3/8*M1^2*pDp^3
  + 1/8*pDp^3*pDk + 1/16*pDp^3*kDk + 11/16*pDp^4 )
 
Id,C33(M1~,M2~,M3~) = 
 + i*Pi^2*Det^-2
  * ( 5/24*pDp^2*pDk + 5/48*pDp^2*kDk + 5/48*pDp^3 )
 
 + i*Pi^2*Det^-1
  * ( 1/12*M1^2 + 1/8*pDp - 5/12*pDk - 5/24*kDk )
 
 + 1/12*Ax(M1)*Det^-1
 
 + B0(pDp,M1,M1)*Det^-3
  * ( 5/4*pDp^4*pDk + 5/8*pDp^4*kDk + 5/8*pDp^5 )
 
 + B0(pDp,M1,M1)*Det^-2
  * ( 1/3*M1^2*pDp*pDk + 1/6*M1^2*pDp*kDk + 1/6*M1^2*pDp^2
  - 5/3*pDp^2*pDk - 5/6*pDp^2*kDk - 35/24*pDp^3 )
 
 + B0(pDp,M1,M1)*Det^-1
  * ( - 1/6*M1^2 + 17/24*pDp + 1/2*pDk + 1/4*kDk )
 
 + B0(qDq,M1,M1)*Det^-3
  * ( - 5/4*pDp^4*pDk - 5/8*pDp^4*kDk - 5/8*pDp^5 )
 
 + B0(qDq,M1,M1)*Det^-2
  * ( - 1/3*M1^2*pDp*pDk - 1/6*M1^2*pDp*kDk - 1/6*M1^2*pDp^2
  + 5/3*pDp^2*pDk + 5/6*pDp^2*kDk + 35/24*pDp^3 )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( 1/4*M1^2 - 17/24*pDp - 1/2*pDk - 1/4*kDk )
 
 + C0(M1,M2,M3)*Det^-3
  * ( - 5/4*pDp^5*pDk - 5/8*pDp^5*kDk - 5/8*pDp^6 )
 
 + C0(M1,M2,M3)*Det^-2
  * ( - 3/4*M1^2*pDp^2*pDk - 3/8*M1^2*pDp^2*kDk - 3/8*M1^2*pDp^3
  + 15/8*pDp^3*pDk + 15/16*pDp^3*kDk + 25/16*pDp^4 )
 
 + C0(M1,M2,M3)*Det^-1
  * ( M1^2*pDk + 1/2*M1^2*kDk - 1/2*pDp*pDk - 1/4*pDp*kDk
  - 5/4*pDp^2 )
 
Id,C34(M1~,M2~,M3~) = 
 + i*Pi^2*Det^-2
  * ( - 5/24*pDp^2*pDk - 5/48*pDp^2*kDk - 5/48*pDp^3 )
 
 + i*Pi^2*Det^-1
  * ( - 1/12*M1^2 + 3/8*pDp - 1/12*pDk - 1/24*kDk )
 
 - 1/12*Ax(M1)*Det^-1
 
 + B0(pDp,M1,M1)*Det^-3
  * ( - 5/4*pDp^4*pDk - 5/8*pDp^4*kDk - 5/8*pDp^5 )
 
 + B0(pDp,M1,M1)*Det^-2
  * ( - 1/3*M1^2*pDp*pDk - 1/6*M1^2*pDp*kDk - 1/6*M1^2*pDp^2
  + 11/12*pDp^2*pDk + 11/24*pDp^2*kDk + 13/12*pDp^3 )
 
 + B0(pDp,M1,M1)*Det^-1
  * ( 1/6*M1^2 - 1/3*pDp + 1/4*pDk + 1/8*kDk )
 
 + B0(qDq,M1,M1)*Det^-3
  * ( 5/4*pDp^4*pDk + 5/8*pDp^4*kDk + 5/8*pDp^5 )
 
 + B0(qDq,M1,M1)*Det^-2
  * ( 1/3*M1^2*pDp*pDk + 1/6*M1^2*pDp*kDk + 1/6*M1^2*pDp^2
  - 11/12*pDp^2*pDk - 11/24*pDp^2*kDk - 13/12*pDp^3 )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( - 1/4*M1^2 + 1/3*pDp - 1/4*pDk - 1/8*kDk )
 
 + C0(M1,M2,M3)*Det^-3
  * ( 5/4*pDp^5*pDk + 5/8*pDp^5*kDk + 5/8*pDp^6 )
 
 + C0(M1,M2,M3)*Det^-2
  * ( 3/4*M1^2*pDp^2*pDk + 3/8*M1^2*pDp^2*kDk + 3/8*M1^2*pDp^3
  - 9/8*pDp^3*pDk - 9/16*pDp^3*kDk - 19/16*pDp^4 )
 
 + C0(M1,M2,M3)*Det^-1
  * ( - M1^2*pDp + 1/4*pDp^2 )
 
Id,C35(M1~,M2~,M3~) = 
 - 7/36*i*Pi^2
 
 + i*Pi^2*Det^-1
  * ( 1/24*pDp*pDk + 1/48*pDp*kDk + 1/48*pDp^2 )
 
 + B0(pDp,M1,M1)*Det^-2
  * ( 1/4*pDp^3*pDk + 1/8*pDp^3*kDk + 1/8*pDp^4 )
 
 + B0(pDp,M1,M1)*Det^-1
  * ( 1/12*M1^2*pDp + 1/6*M1^2*pDk + 1/12*M1^2*kDk - 5/24*pDp*pDk
  - 5/48*pDp*kDk - 11/48*pDp^2 )
 
 - 1/6*B0(qDq,M1,M1)
 
 + B0(qDq,M1,M1)*Det^-2
  * ( - 1/4*pDp^3*pDk - 1/8*pDp^3*kDk - 1/8*pDp^4 )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( - 1/12*M1^2*pDp - 1/6*M1^2*pDk - 1/12*M1^2*kDk + 5/24*pDp*pDk
   + 5/48*pDp*kDk + 11/48*pDp^2 )
 
 + C0(M1,M2,M3)
  * ( 1/2*M1^2 )
 
 + C0(M1,M2,M3)*Det^-2
  * ( - 1/4*pDp^4*pDk - 1/8*pDp^4*kDk - 1/8*pDp^5 )
 
 + C0(M1,M2,M3)*Det^-1
  * ( - 1/4*M1^2*pDp*pDk - 1/8*M1^2*pDp*kDk - 1/8*M1^2*pDp^2
  + 1/4*pDp^2*pDk + 1/8*pDp^2*kDk + 1/4*pDp^3 )
 
Id,C36(M1~,M2~,M3~) = 
 - 1/18*i*Pi^2
 
 + i*Pi^2*Det^-1
  * ( - 1/24*pDp*pDk - 1/48*pDp*kDk - 1/48*pDp^2 )
 
 + B0(pDp,M1,M1)*Det^-2
  * ( - 1/4*pDp^3*pDk - 1/8*pDp^3*kDk - 1/8*pDp^4 )
 
 + B0(pDp,M1,M1)*Det^-1
  * ( - 1/12*M1^2*pDp - 1/6*M1^2*pDk - 1/12*M1^2*kDk - 1/24*pDp*pDk
   - 1/48*pDp*kDk + 5/48*pDp^2 )
 
 - 1/12*B0(qDq,M1,M1)
 
 + B0(qDq,M1,M1)*Det^-2
  * ( 1/4*pDp^3*pDk + 1/8*pDp^3*kDk + 1/8*pDp^4 )
 
 + B0(qDq,M1,M1)*Det^-1
  * ( 1/12*M1^2*pDp + 1/6*M1^2*pDk + 1/12*M1^2*kDk + 1/24*pDp*pDk
  + 1/48*pDp*kDk - 5/48*pDp^2 )
 
 + C0(M1,M2,M3)*Det^-2
  * ( 1/4*pDp^4*pDk + 1/8*pDp^4*kDk + 1/8*pDp^5 )
 
 + C0(M1,M2,M3)*Det^-1
  * ( 1/4*M1^2*pDp*pDk + 1/8*M1^2*pDp*kDk + 1/8*M1^2*pDp^2
  - 1/8*pDp^3 ) + 0.

Id,N=N_+4
Al,[1-N]^-1=-1/3 + N_/9
Id,N_*Ax(m~) = 2*i*Pi^2*m^2
Al,N_*B0(u~,m~,M~) = - 2*i*Pi^2
Id,N_=0
Id,N=4
Id,Symme,B0,2,3
Id,Ax(m~)=Axf(m)*m^2

Id,r^2=s/4-M^2
Al,pDk=-s/2+M^2
Al,qDq^n~=(-1)^n*s^n
Al,qDp=s/2
Al,qDk=s/2
Al,pDp^n~=(-1)^n*M^(2*n)
Al,kDk^n~=(-1)^n*M^(2*n)
Al,Multi,E^2=s
*yep
B i,Pi,N_
Id,Det^n~=(-1)^n*s^n*r^(2*n)
Id,Axf(m~)= 2*i*Pi^2/N_ + i*Pi^2*(-1+Log(m))
Al,B0(u~,Mx,Mx) = - 2*i*Pi^2/N_ - i*Pi^2*Log(Mx)
*end
