Patches to change the limit on the size of the NeXT Schoonschip RAM
workspace:

size	     |	0000 00EC	0000 0170	0001 E1EC  (hex offsets)
---------------------------------------------------------
1 Meg	     |	0010 0000	000F FFF8	0012 0000
2 Meg	     |	0020 0000	001F FFF8	0022 0000
20 Meg       |	0140 0000	013F FFF8	0142 0000
nn (hex) Meg |	0nn0 0000	0nn0 0000 - 8	0nn2 0000	

The numbers in the top row are hex offsets into the NeXT Schip executable file.

The numbers below them are hexadecimal, long word values.

The first offset contains the total virtual memory size of the DATA section, including BSS.  It must be a multiple of 8K = 0x2000.

The second offset contains the size of the BSS section, which is the same as the limit on the Schoonschip RAM workspace.  This is a bit less than the sum of
the input and output space sizes set by IS= and OS=, because of Schoonschip internal memory overhead.  It is the virtual memory size minus 8 bytes, because
the Schoonschip DATA section is 8 bytes long.

The third offset contains the address of the upper limit in memory, which is
0x20000 + virtual memory size (the DATA section begins at location 0x20000).


The example we describe now is how to set a 20 Meg memory limit with the Veltman Das program.  Put a scratch copy of Schip in a working directory, and 
enter 

  Das -x Schip
 
from the command line, assuming Das to be in the execution path.

At the resulting prompt, do

  0xEC

to position the file to the offset 0xEC.  Then do

  r,0x1400000

The upper left corner of the display should show 0140 0000 at offset 0000 00EC.
Then do

  0x170
  
to position the upper left corner of the display to offset 0000 0170, followed by

  r,0x13FFFF8
  
Next,

  0x1E1EC
  r,0x1420000

That finishes all the patches.  Finally, do

  w
  
That writes out a copy of the patched file, which will be named Schip.RX.
Fix the protections and rename Schip.RX to complete the procedure.

