Schoonschip manual updates and corrections to manual.

*** Corrections to Schoonschip manual on pages
30: replace } by )}
91: coefficient 33 instead of 3 for a4.
101: spin 3/2 spinsum:

  {D(mu,nu)*Gi(L1,j) - 1/3*i*G(L1,j,mu)*p(nu)/m  + 1/3*i*G(L1,j,nu)*p(mu)/m

	- 1/3*G(L1,j,mu,nu) + 2/3*Gi(L1,j)*p(mu)*p(nu)/m^2 }

	* { - i*G(j,K1,p) + m*Gi(j,K1) }

General: it is erroneously stated that for a substitution the
expression is placed at the location of the first removed function.
For most substitutions this must be last removed function; for
Commu it is to the right (at the end). See below, Left, Right, Last
and First substitution keyword for new possibilities here.

************************** Updates. ******************************

Contents:

1. Use statement for Index names.
2. New command: Chain.
3. Invisible functions.
4. New options for commands Commu, Cyclic and Order.
5. Symmetrization X-expression names and functions in substitutions.
6. Extension Ndotpr command.
7. Left, Right, Last and First substitution keywords.
8. Multiple dummies.
9. Super flags.
10. Forcing substitution levels.
11. New command: Invert.
12. DO-loop's.
13. Generation of X and D statements.
14. Lists for the commands Symme, Asym, Cyclic, Even, Odd.
15. Use of numerical arguments in functions.
16. Spinsum '2-component' spinors.
17. Printing numbers in hex.
The first four features added are mostly intended to improve
output appearance.


1. Use statement for Index names.

Created indices and summation indices are normally given the names
Naa, Nab etc. For a proper understanding it must be noted that such
indices also have a dimension, somehow defined by the problem.
Created indices arise during calculation, summation indices are
defined by the Sum statement.

The Use statement provides for the possibility to introduce other
names for created/summation indices. Syntax:

Use name1,name2,Dim1,name3,name4,name5,Dim2,....

In here name1 etc are the names to be used, in order of occurrence.
By default the first names are associated with dimensionless indices
(i.e. of dimension 4). After a number or single character algebraic
symbol is encountered (Dim1 above) that number or character is taken
to be the dimension of the names following, till the next number or
single character algebraic symbol.

Every Use statement completely erases any previous Use list.
The list may be empty, resulting simply in invalidating the previous.

Names in the Use list must not be used for any other quantity.
Exceptions: the dimension symbols (as Dim1 etc. above) and any
names appearing in a previous Sum list.

Note: a name appearing in a Sum statement is erased immediately
and can be used freely again. For this reason a Sum statement must
be the last in any section, i.e. it must be followed by a * line,
with possibly a Use statement inbetween.

A name occurring in a Use list may be used as index name in any
subsequent section provided that name is erased before the * line,
i.e. it must occur in a Sum list at the end of that section.

Inside Schoonschip the following happens:
- When a Use statement is encountered the list of names is simply
  read in. Any previous list is lost.
- When encountering a * line the names occurring in the Use list are
  checked with all other names to detect duplication.
- At the very end, when printing is to be done, the name list for
  created/summation indices is constructed, using the Use list.

A Use statement remains valid over any * line.

Example:

I al,be=N,ga
I ia=3,ib=3,ic=3,id=3

Z xx=F1(al,be,ga,ia,ib,ic,id)*F2(al,be,ga,ia,ib,ic,id)

Sum al,be,ga,ia,ib,ic,id
Use mu,nu,3,ic,id,N,na
*end

Output:

xx = + F1(mu,na,nu,ic,id,Naa,Nab)*F2(mu,na,nu,ic,id,Naa,Nab) + 0.


2. New command: Chain.

This command allows the chaining of matrices on the basis of indices.
Suppose an expression of the form:

 A(i2,i3)*B(i1,i2)*C(i3,i1)

If A, B and C are matrices then this may also be written as

 B*A*C

or rather the trace of B*A*C. The command

Id,Chain,i1,i2,i3

achieves just that (output A*B*C); in case that the trace must be
made explicit the function that is to be used must be mentioned first:

Id,Chain,Tr,i1,i2,i3

where Tr must have been declared to be a function previously. The
output is now

 Tr(A,B,C)

Do not use the function name Trace, as it is used internally for
other purposes (Trick,Trace command).

If the chain terminates at begin or end in a function with one
index only, then such a function is seen as a terminator of the
string. Thus:

 X(i1)*A(i2,i3)*B(i1,i2)*C(i3,i4)*Y(i4)

with

Id,Chain,i1,i2,i3,i4

becomes

 X*B*A*C*Y

If there is only one function specified then that is not used here, as
it is no trace but a string. However, if a second function is specified
then that is used. Thus

Id,Chain,Tr,St,i1,i2,i3,i4

would now give

 St(X,B,A,C,Y)

The following rules apply:

- If the functions A, B etc have additional arguments then those
  are kept in the result;
- All indices in a chain must be paired. If the chain starts and/or
  finishes with a single index, then nothing is done to that chain.
  This can be overruled: mentioning the character "S (for single)
  as first argument, even before a possible function, forces
  also treatment of such situations. The single first (last) index
  is put as first (last) argument of the first (last) function.
- The collected chains are put after all other functions. The option
  "B may be specified, with the result that the chains are put at
  the begin.
- Traces are circularly rotated to a well defined position (smallest
  first).

Thus, general format:

Id,Chain,"S,"B,F1,F2,i1,i2,...

with optional "S (do single index also), "B (put chain at begin),
F1 (trace function) and F2 (second function = string function).
The relative order of the options is irrelevant except that
the string function F2 is the second function.

Examples:

I i1,i2,i3,i4,i5,i6
F Tr

Z xx =
 f1(ab1,i2,i3,def)*f2(ab1,i1,i2)*f3(i3,i1,ab3)
 + f1(ab1,i2,i3,def)*f2(ab1,i2)*f3(i3,ab3)

Id,Chain,Tr,i1,i2,i3,i4
*end

gives

xx = + Tr(f1,ab1,def,f3,ab3,f2,ab1)
 
 + f2(ab1)*f1(ab1,def)*f3(ab3) + 0.
 
Next, using also the Use statement:

F X_,Y,Wg,Tr,U
I mu,nu,ic,id

Z xx = Wg(mu,ic,id)*U(mu)*X_(nu,ic)*Y(id,nu)

Id,Chain,Tr,ic,id
Id,Commu,Tr
Sum,mu,nu
Use mu,nu
*end

This gives:
 
xx = + U(mu)*X_(nu)*Wg(mu)*Y(nu) + 0.

Open ended:

Z xx = Wg(mu,ic,id)*U(mu)*X_(nu,ic)*Y(nu)

Id,Chain,Tr,ic,id,ie,if
Id,Commu,Tr
Sum,mu,nu
Use mu,nu
*end

Nothing is done:

xx = + Wg(mu,ic,id)*U(mu)*X_(nu,ic)*Y(nu)

Now specifying the "S option:

Z xx = Wg(mu,ic,id)*U(mu)*X_(nu,ic)*Y(nu)

Id,Chain,"S,Tr,ic,id,ie,if
Id,Commu,Tr
Sum,mu,nu
Use mu,nu
*end

xx = + U(mu)*Y(nu)*X_(nu)*Wg(mu,id) + 0.

The right side open ended chain X_, Wg is put at the end.


3. Invisible functions.

Ordering of the output on the basis of the terms as they appear
is not always the most appropriate one. To influence ordering
without any other consequence the following method has been
implemented.

First, the count statement, with a function as first argument,
has been slightly modified: the resulting function whose arguments
contain the various counts is now placed before all other functions
(instead of at the end). This function will then be the first
considered when ordering the terms, assuming it appears in the
output.

Note: if necessary this can be changed easily. The Commu command
may be used to place specified functions at the end.

Secondly, this function may be declared "invisible". The consequence
of that is that this function will be removed from all terms prior
to printing etc., but after the ordering process. Thus in the output
terms will be ordered as defined by the "invisible" function, but
the function itself disappears.

There is a problem with respect to ordering on the basis of a function
with numerical arguments. This ordering is done treating numbers as
unsigned quantities (i.e. the - sign is part of the number). For
example, -1 is seen as 255, i.e. the largest possible. Effectively
the ordering is:
 0 1 2 .... 127 -128 -127 ... -1
Especially for the purposes considered here that is usually not what is
desired. For this reason one may specify an offset in the Count statement;
this offset is added to the resulting number, which is then taken
modulo 256. The natural offset is 128; then ordering becomes like
the usual signed ordering. Thus 0 and up becomes 128 (= -128) up,
-1 becomes 127, and -128 becomes 0.

An offset may be specified in the Count statement by means of the
character arguments "N and "O. They must be the very first first,
preceeding all other arguments. The "N specifies natural ordering,
i.e. 128 is added to all function arguments. The character "O must
be followed by a number, and that number is then the offset used.
Example:
 Id,Count,"N,F1,a,1,b,-7
The term a^2 gives F1(-126), and b^2 gives F1(114). In the output
the term b^2 appears before the a^2 term:

xx = + F1(114) * ( b^2 ) + F1(-126) * ( a^2 )
 
Similarly:
 Id,Count,"O,7,F1,a,1,b,-7
gives

xx = + F1(9) * ( a^2 ) + F1(-7) * ( b^2 )

To statement Invisible may be used to specify one (and no more
than one) invisible function. Syntax:

Invisible F1

The name F1 is entered in the function list, if not yet present
there. The command takes effect at the output at the next * line.
After that the function is no more invisible. Thus, the validity
of the statement is till the next * line. The function may appear
more than once; they are all erased, also if they do not appear
as first. Thus one may have more than one Count statement involving
always the same function. The result will be a product of as many
of these functions in front.

Example:

F F1,F2
Z xx=F1(-a,b)*a1*a2*a3^2*F1(a,b,c)
 - F3(-a,b)*a1*a2^-2*a3^2*F1(a,b,c)
 + abc*def*a3

Id,Count,"N,F2,a3,-7 : a1,1,a2,3
*end


F F1,F2
Z xx=F1(-a,b)*a1*a2*a3^2*F1(a,b,c)
 - F3(-a,b)*a1*a2^-2*a3^2*F1(a,b,c)
 + abc*def*a3

Id,Count,"N,F2,a3,-7 : a1,1,a2,3
Invisible F2
*end

Output first:

xx = 
 + F2(114,123)*F3(-a,b)*F1(a,b,c)
  * ( - a1*a2^-2*a3^2 )

 + F2(114,-124)*F1(-a,b)*F1(a,b,c)
  * ( a1*a2*a3^2 )

 + F2(121,-128)
  * ( a3*abc*def ) + 0.

Output second differs as F2 is removed before printing:

xx = 
 + F3(-a,b)*F1(a,b,c)
  * ( - a1*a2^-2*a3^2 )

 + F1(-a,b)*F1(a,b,c)
  * ( a1*a2*a3^2 )

  + a3*abc*def + 0.


At this moment no such procedure affecting ordering within the
algebraic part has been implemented. Note however that a
purely algebraic expression (no functions, vectors etc.)
may be given a factor containing a function through a Count
statement, implying ordering. Here an example. First without
any specific ordering procedure:

Z xx=(a+b)^5/a^2
*begin

Result:
 
xx =  + 10*a*b^2 + 5*a^2*b + a^3 + a^-2*b^5 + 5*a^-1*b^4 + 10*b^3 + 0.

With ordering:

Invisible F1
Z xx=(a+b)^5/a^2
Id,Count,"N,F1,a,1
*end

Note that F1 is declared to be a function through the invisible
statement. Output:

xx = 
  + a^-2*b^5
 
  + 5*a^-1*b^4
 
  + 10*b^3
 
  + 10*a*b^2
 
  + 5*a^2*b
 
  + a^3 + 0.
 

4. New options for commands Commu, Cyclic and Order.

Two new options have been implemented for the command Commu.
The action of this command is to collect specified functions, to
order them in some well defined way (as usual, smallest first),
and then to place them at the end (at the right hand side of the term).
This command can also be used for a single function; it then moves
that function to the end.

Now Left, Right, First or Last can be used to dictate the placement
of the commuting functions. The option "B overides that, and if
given causes placement on the left (the beginning). Default here
is placement to the right, not at the location of the last function
as for most other cases.

The option "N inhibits the ordering of the functions, i.e. they are
moved either to the end or the begin, depending on whether the option
"B was specified, but remain in the same order as in which they appear
originally. Here an example.

F f3,f1,f2,f4
Z xx=f1(a,b,c)*f2(a1,a2)*f3*f4(b1,b2)
Id,Commu,f1,f3
*end
 
xx = + f2(a1,a2)*f4(b1,b2)*f3*f1(a,b,c) + 0.
 
With the "B (or Left) option:

Id,Commu,"B,f1,f3
 
xx = + f3*f1(a,b,c)*f2(a1,a2)*f4(b1,b2) + 0.

With the "N option:
 
Id,Commu,"N,f1,f3
 
xx = + f2(a1,a2)*f4(b1,b2)*f1(a,b,c)*f3 + 0.

With both "B and "N option:
 
Id,Commu,"N,"B,f1,f3
 
xx = + f1(a,b,c)*f3*f2(a1,a2)*f4(b1,b2) + 0.

The command Cyclic allows now argument groups. While the cyclic
permutation is as before, it is done on the basis of the first
argument of the groups only. Here an example:

A m1,m2,m3
I i1,i2,i3
F f,f1
Z xx= f(m2,i2,m1,i1,m3,i3)
Id,Cyclic,f,1,2,3,4,5,6
*begin

This is the old way. The smallest argument comes first:
 
xx = + f(i1,m3,i3,m2,i2,m1) + 0.
 
Now with argument groups:

A m1,m2,m3
I i1,i2,i3
F f,f1
Z xx= f(m2,i2,m1,i1,m3,i3)
Id,Cyclic,f:1,2:3,4:5,6
*begin

Now the group headed by the smallest argument comes first:

xx = + f(m1,i1,m3,i3,m2,i2) + 0.
 

Begin. Time 1 sec.
	A m1,m2,m3
	I i1,i2,i3
	Z xx=f(m3,i3,m1,i1,m2,i2)
L 1	Id,Symme,f:1,2:3,4:5,6:
	*end
 
xx = + f(m1,i1,m2,i2,m3,i3) + 0.
 

End run. Time 1 sec.

The command Order, using mostly routines that were needed for
gamma-matrix work, allows now one new option. When collecting
("C option) only the first index of a string is kept. Specifying
the option "L causes mentioning of the last index as ell. Example:

I s1,s2,s3,s4
Z xx =f1(s1,s2,A)
 *f1(s3,s4,C)
 *f1(s2,s3,B)
Id,Order,"C,f1,1,2
*end

This produces the output  xx = + f1(s1,A,B,C) + 0.

Specifying the "L option,

Id,Order,"C,"L,f1,1,2

produces the output  xx = + f1(s1,s4,A,B,C) + 0.

If a number is specified:
I s1,s2,s3,s4
Z xx =
 f1(s1,s2,A)*f1(s3,s4,C)*f1(s2,s3,B)
 *f2(s1,s2,A)*f2(s3,s4,C)*f2(s2,s3,B)
Id,Order,20,"C,"L,f1,f2
*end
 
xx = + f1(20,21,A,B,C)*f2(22,23,A,B,C) + 0.

Without the "L the output would have been:
 
xx = + f1(20,A,B,C)*f2(21,A,B,C) + 0.


5. Symmetrization X-expression names and functions in substitutions.

In connection with character summation and Compo use, X-expressions must
have names in which the characters appear in 'natural' alphabetical order
(with A_ just before A, A before a and numbers as last). In such cases the
arguments of the X-expression are usually associated with the name; the
arguments will generally go in groups, each group associated with a
character. This is cumbersome to do by hand, simply because the ordering
tends to be confusing, or because a change in name of some particle
may cause extensive rewriting.

It is possible to instruct Schoonschip to do the necessary shuffling.
Here an example. Consider the following X-expression:

X BAC(b1,b2,a1,a2,c1,c2)= ...

For use with Compo this must be rewritten as

X ABC(a1,a2,b1,b2,c1,c2)=...

This is done automatically by Schoonschip if the = sign is replaced
by a colon (:):

X BAC(b1,b2,a1,a2,c1,c2): ...

Schoonschip will reshuffle this to the desired form as shown above.
In doing so Schoonschip assumes that the number of dummies is a
multiple of the number of characters (i.e. here that 6 is a multiple
of 3).

It is possible to attach further characters to the X-expression name
not to be involved in the symmetrization process:

X BAC~AB(b1,b2,a1,a2,c1,c2): ...

is rearranged to

X ABCAB(a1,a2,b1,b2,c1,c2)=...

The ~ serves as separator. If there are two ~ then the first group
is taken to be characters to be put in front:

X K~BAC~AB(b1,b2,a1,a2,c1,c2): ...

gives

X KABCAB(a1,a2,b1,b2,c1,c2)=...

Finally also the argument groups to be shuffled may be indicated using
a semicolon as separator:

X L~BAC~AB(x1,x2;b1,b2,a1,a2,c1,c2;z1,z2): ...

is rearranged to

X LABCAB(x1,x2,a1,a2,b1,b2,c1,c2,z1,z2)=...


For substitutions involving only one function the same notation is allowd.
All arguments must be dummies. Here the complete case, involving also a
substitution:

F F1
X BAC(b1,b2,a1,a2,c1,c2): F1(a1,a2,b1,b2,c1,c2)
X BAC~AB(b1,b2,a1,a2,c1,c2): F1(a1,a2,b1,b2,c1,c2)
X K~BAC~AB(b1,b2,a1,a2,c1,c2): F1(a1,a2,b1,b2,c1,c2)
X L~BAC~AB(x1,x2;b1,b2,a1,a2,c1,c2;z1,z2): F1(x1,x2,a1,a2,b1,b2,c1,c2,z1,z2)
P lists
Z xx = t1*ABC(1,2,3,4,5,6)
     + t2*ABCAB(1,2,3,4,5,6)
     + t3*KABCAB(1,2,3,4,5,6)
     + t4*LABCAB(xx1,xx2,1,2,3,4,5,6,yy1,yy2)
     + labck(p1,p2,y1,y2,y3,q1,q2)

Id,l~bac~k(x1~,x2~;xb~,xa~,xc~;z1~,z2~): hello*F1(x1,x2,xa,xb,xc,z1,z2)
*end

The output is:

A i=i, t1, t2, t3, t4, xx1, xx2, yy1, yy2, p1, p2, y1, y2, y3, q1, 
  q2, hello

F D, Epf=i, G=i, Gi, G5=i, G6=c, G7, Ug=c, Ubg, DD, DB, DT, DS, DX, 
  DK, DP, DF=u, DC, F1, labck

E ABC=X1, ABCAB=X1, KABCAB=X1, LABCAB=X1
 
xx = 
 + F1(xx1,xx2,1,2,3,4,5,6,yy1,yy2)
  * ( t4 )
 
 + F1(p1,p2,y1,y2,y3,q1,q2)
  * ( hello )
 
 + F1(1,2,3,4,5,6)
  * ( t1 + t2 + t3 ) + 0.
 

End run. Time 39 sec.


6. Extension Ndotpr command.

The Ndotpr command applies to functions created with the help of the
All command with a function specified rather then a vector. In
particular this mostly applies to gamma manipulations, and the
corresponding All command would take the form:

Id,All,G,N,F1

All vectors are taken out of the G function and collected as arguments
to the function F1. At the sdame time indices are created, here of
dimensionality N. For example,

 G(1,1,mu,G5,p,q,nu,G5,q,p)

becomes

 G(1,1,mu,G5,Naa,Nab,nu,G5,Nac,Nad)*F1(p,q,q,p,Naa,Nab,Nac,Nad)

One may work on that with the Ndotpr command, as described in the
manual.

To have more control on this another option has been implemented.
Again, considering the above, suppose that the vectors that are
not purely 4-dim. (for example p, but not q) have been taken out
already with the usual vector version of the All command, or
simply manually from the start. Thus now we have:

 G(1,1,mu,G5,Naa,q,nu,G5,q,Nab)*F1(Naa,Nab)

where F1(Naa,Nab) is in fact p(Naa)*p(nab). Now the Ndotpr command
may be used, but the vector p must be specified:

Id,Ndotpr,F1,p,p

The vector p must be specified twice, as F1 has two arguments. The function
F1 is understood as F1(Naa,Nab) = p(Naa)*p(Nab). One may actually specify
different vectors; thus

Id,Ndotpr,F1,p,p,q

would interpret occurrence of F1(Naa,Nab,Nac) as p(Naa)*p(Nab)*q(Nac).

Briefly, an Ndotpr command with only one function assumes that the
vectors required are specified within that function. If vectors occur
in the Ndotpr command then these are taken to be the vectors needed.


7. Left, Right, Last and First substitution keywords.

Normally, functions resulting from a substitution are placed to the
right of the term, or, if the substitution involved removal of
functions, often at the location of the last function. For example,
the factor mentioned in an Addfa statement is placed to the right:

Z xx = f1(a,b,c)
Id,Addfa,f2(e)

The result is

 f1(a,b,c)*f2(e)

In a more complicated case:

Z xx = f1(a)*f2(b)*f3(c)*f4(d)*f5(e)
Id,Ainbe,f2(b)*f4(d)=ff(a)

The result is:

 f1(a)*f3(c)*ff(a)*f5(e)

To provide more flexibility other placements can now be specified.
One may use the keywords 'Left", 'Right', 'Last' and 'First' (upper
or lower characters may be used). The consequence is placement of
the substitution at the left, right, or at the location of the first
removed function. Default remains placement at the location of the
last removed function. If there are no functions removed the
keyword 'First' has the same effect as the keyword 'Left'.
Here some examples:

Z xx = f1(a,b,c)
Id,Left,Addfa,f2(e)         		=> f2(e)*f1(a,b,c)

Z xx = f1(a)*f2(b)*f3(c)*f4(d)*f5(e)
Id,Left,Ainbe,f2(b)*f4(d)=ff(a)		=> ff(a)*f1(a)*f3(c)*f5(e)

Z xx = f1(a)*f2(b)*f3(c)*f4(d)*f5(e)
Id,Right,Ainbe,f2(b)*f4(d)=ff(a)	=> f1(a)*f3(c)*f5(e)*ff(a)

Z xx = f1(a)*f2(b)*f3(c)*f4(d)*f5(e)
Id,First,Ainbe,f2(b)*f4(d)=ff(a)	=> f1(a)*ff(a)*f3(c)*f5(e)

Z xx = f1(a)*f2(b)*f3(c)*f4(d)*f5(e)
Id,Last,Ainbe,f2(b)*f4(d)=ff(a) 	=> f1(a)*f3(c)*ff(a)*f5(e)


8. Multiple dummies.

Multiple dummies are now allowed. They refer to a string of function
arguments of variable length. A multiple dummy is designated by
a question mark (?) following the symbol rather than the tilde (~).
Nothing better than an example here:

F f1,f2,f3,ff2
A a,b,c,d,e,f,ff,a1,a2,a3

Z xx = f1(a,b,c,d,e,f,ff)* f3(a1,b)

Id,f1(a1~,a2?,ff)=a*f2(f,a2,ff,c)

*end

In here a1 is a dummy as usual, and a2 is a multiple dummy.
The substitution succeeds, with for a1 the variable a, and for
a2 the serie of arguments  b,c,d,e,f.

Result:  f3(a1,b)*f2(f,b,c,d,e,f,ff,c)

The argument ff acts as a delimiter for the string of arguments.
The substitution

Id,f1(a1~,a2?)=a*f2(f,a2,ff,c)

would have given the sequence b,c,d,e,f,ff for a2 and would give
the result  f3(a1,b)*f2(f,b,c,d,e,f,ff,ff,c)

Multiple dummies may also be repetitive dummies, and then any
recurrence is checked for identical length and content.
Example:

Z xx = f1(a,b,c,d,e,f,ff,b,c,d,e,f)* f3(a,b)
Id,f1(a1~,a2?,ff,a2?)*f3(a1~,b)=f2(f,a2,ff,a1)

The multiple dummy a2 is in both cases the identical string,
namely the sequence b,c,d,e,f, and the substitution succeeds.
The result is:

 f2(f,b,c,d,e,f,ff,a)
 
A multiple dummy may also be empty. Example:

Z xx = f1(a,ff)* f3(a,b)
Id,f1(a1~,a2?,ff,a2?)*f3(a1~,b)=f2(f,a2,ff,a1)

The result is

 f2(f,ff,a)

The repetitive multiple dummy a2 is empty here.


9. Super flags.

There are now 32 'super flags' inside Schoonschip. They are
initially zero, and may be set or cleared, and tested for on
or off. They are valid throughout, over * lines up to the
last *end statement. They may be set or cleared in the first
problem, and tested in the last. Here are the possible statements.

Id,Flag,set,#
Id,Flag,clear,#
IF Flag,on,#
IF Flag,off,#

The first two statements serve to set or clear a flag specified
by the number # (must be in the range 0-31). The last two statements
simply test the status of the flag. Instead of IF one may have
also have IF NOT etc. Here is an example. If # is not mentioned
then by default it is taken to be zero.

Suppose in the first problem a file is generated for which it is
important to know if a certain variable, say x1, occurs. That
knowledge could be transferred to the last problem using a flag.
Thus:

C Problem 1.
Z Fnam = ....
 :
*yep
IF x1
Id,Flag,set,13
ENDIF
*begin
 :
 :
C Problem 15.
Z xx = ... + abc
IF Flag,on,13
Id,abc=Fnam
ELSE
Id,abc=0
ENDIF
 :
*end


10. Forcing substitution levels.

It is possible to reset the substitution level count. The
syntax is:

 LF #

where # is in the range 1-40. This feature must be used only
with the greatest care. It may be useful if there are two or more
completely independent substitution sequences. Example:

Id,xx=...
Al,...
 :
LF 1
Id,yy=...
Al,...
 :

For this to work properly, including the case that IF's occur, it is
necessary that the substitutions are not interfering with each other.
For example, if on level 3 some substitution in the first group
contains an IF or IF NOT statement, then the action of that IF or
IF NOT would not only apply to statements at level 4 of the first
group, but also to those of level 4 of the second group.


11. New command: Invert.

This command leads to inverting terms. Thus 3*a^n becomes 1/3*a^-n
and pDq^n similarly pDq^-n. With respect to functions the default
action is to do nothing. If however in the function list a function
name is either followed or preceeded by the same name with an
underscore appended then those functions are considered each
other's inverse with respect to this statement. Example:

A a,b,c,d,e
F f1,f2,f2_
I i1,i2
V p,q
Z xx = 3*a^3*pDq^-3*i1^7*f1(b,c)
 +  1/13*c^3*pDq^-3*i1^7*f2_(a,b)
 +  1/7*b^3*pDq^-3*i1^7*f2(d,e)
Id,Invert
*end

The result is:
 
xx = + f1(b,c)
  * ( 1/3*a^-3*i1^-7*pDq^3 )
 
 + f2(a,b)
  * ( 13*c^-3*i1^-7*pDq^3 )
 
 + f2_(d,e)
  * ( 7*b^-3*i1^-7*pDq^3 ) + 0.


12. DO-loop's.

Some slight changes have been made to DO-loops. First, the range of
the variables is now from -16383 to +16383, except for the third
variable, the increment, whose range is half of that. Secondly,
occurence of the DO variables in the text may now be simple
arithmetic expressions. Thirdly, there is now the possibility of
character variables.

DO variables can now appear in simple arithmetic expressions.
A simple arithmetic expression has only + _ * and / as operators,
no brackets, and is evaluated using integer arithmetic. The
numbers must remain in the range -32767, + 32767 at all times
during the calculation. The whole simple arithmetic expression
must be put inbetween single quotes ('), and the DO variables
in there must not be enclosed in quotes. Only numbers may
appear aside from DO variables. Here is an example:

DO ii=1,3
Z xx'ii' = '2*ii+7'*a
ENDDO

The expression 2*ii+7 is evaluated numerically and the resulting
number is translated to text and inserted.

There is a not directly visible consequence. A number in single
quotes is now evaluated and re-inserted. Thus '23' is translated
to 23 (quotes are removed).

If the expression occurs in a block th expression must be
enclosed between two single quotes. Block arguments, enclosed
in simple quotes, may be used inside the expression, provided
they become numbers when the block is called. Example:

BLOCK Hup{x}
DO ii='x',3
Z x'ii' = ''2*ii+'x'/2-27''
ENDDO
ENDBLOCK
Hup{2}
*end

It should be noted that while reading a block two subsequent
single quotes are replaced by one single quote.

In the above the block variable x becomes 2 when the block is
called. Here is the output:

> BLOCK Hup{x}
> DO ii='x',3
> Z x'ii' = ''2*ii+'x'/2-27''
> ENDDO
> ENDBLOCK
> Hup{2}
	DO ii=2,3
	Z x2 = %22
	ENDDO
	*end
 
x2 =  - 22
 
x3 =  - 20 + 0.

Now character variable. A DO-loop may be specified as follows:

 DO ii="x","y",#

where x and y may be any of the characters 0-9, A-Z or a-z.
Actually, if x or y are not 0-9 one may omit the double quotes.
The variable ii is initially the character x, and moves up (or
down) by the number specified by # up to the character y. Here
is an example:

A var0
DO ii="2","H",2
 ,var'ii'
ENDDO
> P lists
*end

This produces the A-list:

A i=i, var0, var2, var4, var6, var8, varA, varC, varE, varG

Character DO variables can not be part of a DO argument simple
arithmetic expression as discussed above.


13. Generation of X and D statements.

Schoonschip can now accomodate a truly large amount of X and
D expressions (four thousand, can be more for special versions).
Of course, that many expressions would also need a large input
space, since X and D expressions are stored there.

The computer generation of such expressions is mainly a matter
of cosmetics. Suppose that two X expressions are to be generated,
namely the expression for (a+b)^4 and another expression for
(a+b)^5. Regular Schoonschip for such expressions would be:

	Z AB4(a,b)=(a+b)^4
	Z AB5(a,b)=(a+b)^5
	*end
 
AB4(a,b) =  + 4*a*b^3 + 6*a^2*b^2 + 4*a^3*b + a^4 + b^4
 
AB5(a,b) =  + 5*a*b^4 + 10*a^2*b^3 + 10*a^3*b^2 + 5*a^4*b
  + a^5 + b^5 + 0.

End run. Time 0 sec.

To make this output like an X-expression one needs to write X
in column one, followed by a blank. To achieve this put a line
with XX in front. This instructs Schoonschip to print the output
to look as much as possible as an X-expression. Among others
input printing is suppressed, and the last line, End run, is
changed into just an End statement (end of an external file):

	XX
 
X AB4(a,b) =  + 4*a*b^3 + 6*a^2*b^2 + 4*a^3*b + a^4 + b^4
 
X AB5(a,b) =  + 5*a*b^4 + 10*a^2*b^3 + 10*a^3*b^2 + 5*a^4*b
  + a^5 + b^5 

End

Writing this output to some file one can later read that file
as an external file in another problem. Then the expressions
are read as X-expressions.

Perhaps a D expression containing several expressions must be
created. Do this by inserting a line with DD. The result is
that the first time the name is written (preceeded by D for
D expression), while for all subsequent files no name is written
but just a comma. Also, the reulting expressions are put in
brackets. Here the result for the above case, but now with DD:

	DD
 
D AB4(n,a,b) = (  + 4*a*b^3 + 6*a^2*b^2 + 4*a^3*b + a^4 + b^4)
 
 , (  + 5*a*b^4 + 10*a^2*b^3 + 10*a^3*b^2 + 5*a^4*b + a^5
  + b^5) 

End

It is the responsabilty of the user to produce the correct
names and arguments for the X and D expressions. Thus the input
for the last case has as first filename:

Z AB4(n,a,b)

The following filename(s) in a D series are not printed anyway,
so do not matter. Note that it is allowed to have n occurring
in the expressions.
 
One may in fact create many X and D expressions in one run.
Schoonschip remembers the XX and DD lines over a * line.
Here is an example. The input is:

XX
Z AB4(a,b)=(a+b)^4
Z AB5(a,b)=(a+b)^5
*begin
Z AB6(a,b)=(a+b)^6
*begin
DD
Z POW(n,a,b,c)=a+b+c
DO II=2,5
Z x'II'=(a+b+c)^'II'
B a
ENDDO
*begin
XX
Z AB7(a,b)=(a+b)^7
*end

The X expressions AB4 and AB5 are written, followed by the
D expressions POW with 5 sub-expressions, and finally the
X expression AB7. Here is the output, written to file XDexpr.e,
including leading and terminating lines.

C       Schoonschip, 68000 version of Jan 1, 1994. Public version.
 Date: Tue Dec 21 1993 00:04:04.  Memory: start 0001C1E0, length 476876.

 Command line: MakeXD.e XDexpr.e

	XX
 
X AB4(a,b) =  + 4*a*b^3 + 6*a^2*b^2 + 4*a^3*b + a^4 + b^4
 
X AB5(a,b) =  + 5*a*b^4 + 10*a^2*b^3 + 10*a^3*b^2 + 5*a^4*b
  + a^5 + b^5 
 
X AB6(a,b) =  + 6*a*b^5 + 15*a^2*b^4 + 20*a^3*b^3 + 15*a^4*b^2
  + 6*a^5*b + a^6 + b^6 
 
D POW(n,a,b,c) = (  + b + c
 + a)
 
 , (  + 2*b*c + b^2 + c^2
 + a
  * ( 2*b + 2*c )
 + a^2)
 
 , (  + 3*b*c^2 + 3*b^2*c + b^3 + c^3
 + a
  * ( 6*b*c + 3*b^2 + 3*c^2 )
 + a^2
  * ( 3*b + 3*c )
 + a^3)
 
 , (  + 4*b*c^3 + 6*b^2*c^2 + 4*b^3*c + b^4 + c^4
 + a
  * ( 12*b*c^2 + 12*b^2*c + 4*b^3 + 4*c^3 )
 + a^2
  * ( 12*b*c + 6*b^2 + 6*c^2 )
 + a^3
  * ( 4*b + 4*c )
 + a^4)
 
 , (  + 5*b*c^4 + 10*b^2*c^3 + 10*b^3*c^2 + 5*b^4*c + b^5
  + c^5
 + a
  * ( 20*b*c^3 + 30*b^2*c^2 + 20*b^3*c + 5*b^4 + 5*c^4 )
 + a^2
  * ( 30*b*c^2 + 30*b^2*c + 10*b^3 + 10*c^3 )
 + a^3
  * ( 20*b*c + 10*b^2 + 10*c^2 )
 + a^4
  * ( 5*b + 5*c )
 + a^5) 
 
X AB7(a,b) =  + 7*a*b^6 + 21*a^2*b^5 + 35*a^3*b^4 + 35*a^4*b^3
  + 21*a^5*b^2 + 7*a^6*b + a^7 + b^7 

End

This file may be an external file to another problem. To give an
idea, the above expressions need about 2.5 kB of input space. Here
is an exampleof its use:

Read XDexpr.e
A c,d,e
Z xyz=POW(3,c,d,e)
*end

If there are many X and D expressions in file XDexpr.e one may
conveniently issue a P ninput line before the Read statement.


14. Lists for the commands Symme, Asym, Cyclic, Even, Odd.

Ordering for these commands is normally done on the basis of
smallest first, i.e. first mentioned first, indices before
vectors before symbols etc. It is now possible to specify
a lists on the basis of which the priority is decided.
This list must be in the beginning of the command and be
enclosed by the character "L. Example:

A m1,m2,m3
F f
Z xx= f(m2,2,-m1,1,m3,3)
Id,Cyclic,"L,-m1,m2,f1,"L,f,1,2,3,4,5,6
*end

Note that quantities in the list may be signed. The output is:
 
xx = + f(-m1,1,m3,3,m2,2) + 0.


15. Use of numerical arguments in functions.

Normally, expressions in brackets can not pass over a * line.
To some limited extend this is now possible. There are
however strong limitations on those expressions. Principally,
they should be purely numerical at the moment of appearance
in the output, although in case of a *yep it is allowed to have
expressions of one term in which also other quantities may appear.

Furthermore, some new command has been introduced to operate
to some extend on numerical function arguments.

The new command is called Rnum. The idea is that certain
function arguments may come in pairs and then represent actually
a rational number. Thus something like  f1(a,b,2,3,c) might, by
convention, be understood as f1(a,b,1/3,c), with the 1/3
taking two argument places. With that understanding Rnum may work
on this type of arguments.

First, Rnum may convert a numerical expression into two numbers,
with these two numbers being a rational number closest to the
numerical value of the expression. Note that both numbers are
limited to the range -127 to 127.

Secondly, a sequence of two arguments, interpreted as a rational
number, may be simplified (common factors divided out). Thus
for example f1(a,b,4,6) would be simplified to f1(a,b,2,3).
The advantage of all this that in this form one may refer to
these functions in a substitution (where no expressions in
brackets are allowed.

Here is the syntax:

Id,Rnum,f1,2,5,f2

Action: if f1 is seen arguments 2 and 5 are inspected. If they
are expressions in brackets they are evaluated to a rational
number and the corresponding two arguments are inserted at the
location of the expression. If the argument inspected is a short
number then if the following argument is also a short number
then the pair is considered a rational number and simplification
is attempted. If the expression is not numerical, or there are
no short numbers seen nothing is done.

By default, if no numbers follow the function name then all
arguments are considered.

If the numbers encountered are outside the range -127, 127 then
the rational number -1/0 or 1/0 is produced. Thus f1(a,(131)) would
become f1(a,1,0).

Here is an example, showing also survival over a *yep:

A a,c,d,e
Z xx=f1(a,-17,85,b,(21),(-3.14))*f3(9,2)
Id,f3(d~,e~)=f2(b,65,13,b,c,(3*d+e/3),(-511))
*yep
Id,Rnum,f1,2,6,f2
*end

Here is the output:
 
xx = + f1(a,-1,5,b,21,-22,7)*f2(b,5,1,b,c,83,3,-1,0) + 0.
 
Note that at the expression (3*d+e/3) becomes numerical as soon as
e and d are defined, and as such can cross a * line.

Note also that not enclosing this expression in brackets would have
given a very different result, as then 3*d+e/3 would have been
evaluated to an integer. So, either enclose an expression in brackets
or else specisy a pair of number if they have to be worked on by
the command Rnum.

16. Spinsum '2-component' spinors.
Two-component spinors have a spinsum that is just the identity.
Without trying to implement that in all details, nonetheless
the following feature has been added.
A spinor with the additional argument "2 (i.e. character 2) is
considered a special spinor. The spinsum will be just m*Gi(L)
as compared to -i*G(L,p)+m*Gi(L) for the normal spinors.
Here is the notation for these special spinors:
 Ug(L,"2,m,p) and Ubg(L,"2,m,p)
L is the gamma loop index, m is the mass and p the momentum.
Be aware that the resulting expression is still like a gamma
matrix, thus 4x4. Traces remain as they are, always involving
a factor 4.

Thus:
Z Spin=Ug(I1,m,p)*Ubg(I2,m,p)
Z Spin2=Ug(I1,"2,m,p)*Ubg(I2,"2,m,p)

gives the output:

Spin = + G(I1,I2,p)
  * ( - i )
 
 + Gi(I1,I2)
  * ( m )
 
Spin2 = + Gi(I1,I2)
  * ( m ) + 0.

17. Printing numbers in hexadecimal form.
This may be useful for numerical applications. Schoonschip handles numbers
in 96 bit form. The output numbers are printed in hex if one specifies
zero, one or two digits. In the various cases one gets:
Digits 2
Literally the numbers in Schoonschip internal notation (one's complement
 form). First lword exponent, with a bias of 0x2000. The number 1
 is represented by exponent 0x2001 followed by the fraction 0x4000...
 -1 has the same exponent, the fraction is 0xBFFFF...
Digits 1
The number is translated to the Motorola extended format with one extra
 long word:
 First lword: sign (1 bit), exponent (15 bits, bias 0x3FFF), rest 0.
 Fraction: 3 long words. If normalized (always inside Schoonschip) with the
 first bit a 1.
 The number 1 is represented by 0x3FFF0000,0x8000..., -1 by 0xBFFF,0x8000...
Digits 0
 The number is as for the case of Digits 1, except the last long word is
 not shown. Instead rounding is done with respect to the top bit of that
 last word: if set one is added to the second long word.
