C Tests 1.  Test of character DS and command Anti.
C Tests 2.  C-formfactors equation test.
C Tests 3.  Identity among dotproducts.
C Tests 4.  Simple freeze example.
C Tests 5.  Freeze example involving many (261) subfiles.
C Tests 6.  Reproduces the last equation in Gammatrica.
C Tests 7.  Lehmann parameters.
C Tests 8.  Milgram's use of numerics for function args.
C Tests 9.  Milgram's use of numerics for function args. Alternative.
C Tests 10. Spin 3/2.
C Tests 11. Test of Count command with "F option.
C Tests 12. Traces with mixed 4 and N-dim quantities.

*end

C Tests 1.  Test of character DS and command Anti.

G 1
F F1,F2
X XX(k)=k-1*a
T AA: AB_CDBA,EFGH,ABCDBA,AACDAA
T BB: A=1,F=-3
G
C Anti,BB
Z xx=DS(J2;J3;J4;-J2;J3;"C,AA,1:3,5,(F(J2,J3,-J2,-J3,-J4)
 *DC("F,BB,-1,J2)))
P output
*yep

C As a consequence of this A_ must be changed to A, because A in table BB.

Id,Anti,BB
*end

C Tests 2.  C-formfactors equation test.

A Pi,N,N_,m,M,M1,M2,M3,x,y
V p,k
F C0,Cx,Bx,Ax
D YY(I) = pDp,pDk,pDk,kDk
X Y(I,J) = YY(2*I-2+J)
X Cf1 = -pDp
X Cf2 = -qDq+pDp

Z ChR1 = Y(1,1)*C(1,1,m) + Y(1,2)*C(1,2,m) - R1
Z ChR2 = Y(2,1)*C(1,1,m) + Y(2,2)*C(1,2,m) - R2
Z Ch24 = C(2,4,m) - R24
Z ChR3 = Y(1,1)*C(2,1,m) + Y(1,2)*C(2,3,m) - R3
Z ChR5 = Y(2,1)*C(2,1,m) + Y(2,2)*C(2,3,m) - R5
Z ChR4 = Y(1,1)*C(2,3,m) + Y(1,2)*C(2,2,m) - R4
Z ChR6 = Y(2,1)*C(2,3,m) + Y(2,2)*C(2,2,m) - R6

Id,R1=0.5*(Cf1*C0(m) + B0(qDq,m) - B0(kDk,m))
Al,R2=0.5*(Cf2*C0(m) + B0(pDp,m) - B0(qDq,m))
Al,R24 = 1/4*i*Pi^2
  - 0.5*m^2*C0(m) + 1/4*(B0(kDk,m)-Cf1*C(1,1,m)-Cf2*C(1,2,m))
Id,R3=0.5*(Cf1*C(1,1,m)+B1(qDq,m)+B0(kDk,m)) - C(2,4,m)
Al,R4=0.5*(Cf1*C(1,2,m)+B1(qDq,m)-B1(kDk,m))
Al,R5=0.5*(Cf2*C(1,1,m)+B1(pDp,m)-B1(qDq,m))
Al,R6=0.5*(Cf2*C(1,2,m)-B1(qDq,m))-C(2,4,m)

Id,C(1,1,m) = 
 + Det^-1*C0(m)
  * ( 1/2*pDp*kDk + 1/2*pDk*kDk )
 
 - C0(m)
 
 + B0(pDp,m)*Det^-1
  * ( - 1/2*pDk )
 
 + B0(kDk,m)*Det^-1
  * ( - 1/2*kDk )
 
 + B0(qDq,m)*Det^-1
  * ( 1/2*pDk + 1/2*kDk )
 
Al,C(1,2,m) = 
 + Det^-1*C0(m)
  * ( - 1/2*pDp*pDk - 1/2*pDp*kDk )
 
 + B0(pDp,m)*Det^-1
  * ( 1/2*pDp )
 
 + B0(kDk,m)*Det^-1
  * ( 1/2*pDk )
 
 + B0(qDq,m)*Det^-1
  * ( - 1/2*pDp - 1/2*pDk ) + 0.
 
Id,C(2,4,m) = 
 + 1/4*i*Pi^2
 
 + Det^-1*C0(m)
  * ( - 1/4*pDp*pDk*kDk - 1/8*pDp*kDk^2 - 1/8*pDp^2*kDk )
 
 + C0(m)
  * ( - 1/2*m^2 )
 
 + B0(pDp,m)*Det^-1
  * ( 1/8*pDp*pDk + 1/8*pDp*kDk )
 
 + B0(kDk,m)*Det^-1
  * ( 1/8*pDp*kDk + 1/8*pDk*kDk )
 
 + 1/4*B0(qDq,m)
 
 + B0(qDq,m)*Det^-1
  * ( - 1/8*pDp*pDk - 1/4*pDp*kDk - 1/8*pDk*kDk ) + 0.
 
 
Al,C(2,1,m) = 
 + i*Pi^2*Det^-1
  * ( - 1/4*kDk )
 
 + Det^-2*C0(m)
  * ( 3/4*pDp*pDk*kDk^2 + 3/8*pDp*kDk^3 + 3/8*pDp^2*kDk^2 )
 
 + Det^-1*C0(m)
  * ( 1/2*m^2*kDk - pDp*kDk - pDk*kDk - 1/4*kDk^2 )
 
 + C0(m)
 
 + B0(pDp,m)*Det^-2
  * ( - 3/8*pDp*pDk*kDk - 3/8*pDp*kDk^2 )
 
 + B0(pDp,m)*Det^-1
  * ( 3/4*pDk + 1/4*kDk )
 
 + B0(kDk,m)*Det^-2
  * ( - 3/8*pDp*kDk^2 - 3/8*pDk*kDk^2 )
 
 + B0(kDk,m)*Det^-1
  * ( kDk )
 
 + B0(qDq,m)*Det^-2
  * ( 3/8*pDp*pDk*kDk + 3/4*pDp*kDk^2 + 3/8*pDk*kDk^2 )
 
 + B0(qDq,m)*Det^-1
  * ( - 3/4*pDk - 5/4*kDk )
 
Al,C(2,3,m) =
 + i*Pi^2*Det^-1
  * ( 1/4*pDk )
 
 + Det^-2*C0(m)
  * ( - 3/8*pDp*pDk*kDk^2 - 3/8*pDp^2*pDk*kDk - 3/4*pDp^2*kDk^2 )
 
 + Det^-1*C0(m)
  * ( - 1/2*m^2*pDk + 1/2*pDp*pDk + pDp*kDk )
 
 + B0(pDp,m)*Det^-2
  * ( 3/8*pDp*pDk*kDk + 3/8*pDp^2*kDk )
 
 + B0(pDp,m)*Det^-1
  * ( - 5/8*pDp )
 
 + B0(kDk,m)*Det^-2
  * ( 3/8*pDp*pDk*kDk + 3/8*pDp*kDk^2 )
 
 + B0(kDk,m)*Det^-1
  * ( - 1/2*pDk - 1/8*kDk )
 
 + B0(qDq,m)*Det^-2
  * ( - 3/4*pDp*pDk*kDk - 3/8*pDp*kDk^2 - 3/8*pDp^2*kDk )
 
 + B0(qDq,m)*Det^-1
  * ( 5/8*pDp + 1/2*pDk + 1/8*kDk )
 
Al,C(2,2,m) = 
 + i*Pi^2*Det^-1
  * ( - 1/4*pDp )
 
 + Det^-2*C0(m)
  * ( 3/4*pDp^2*pDk*kDk + 3/8*pDp^2*kDk^2 + 3/8*pDp^3*kDk )
 
 + Det^-1*C0(m)
  * ( 1/2*m^2*pDp - 1/4*pDp^2 )
 
 + B0(pDp,m)*Det^-2
  * ( - 3/8*pDp^2*pDk - 3/8*pDp^2*kDk )
 
 + B0(kDk,m)*Det^-2
  * ( - 3/8*pDp*pDk*kDk - 3/8*pDp^2*kDk )
 
 + B0(kDk,m)*Det^-1
  * ( 1/4*pDp - 1/4*pDk )
 
 + B0(qDq,m)*Det^-2
  * ( 3/8*pDp*pDk*kDk + 3/8*pDp^2*pDk + 3/4*pDp^2*kDk )
 
 + B0(qDq,m)*Det^-1
  * ( - 1/4*pDp + 1/4*pDk )

Id,B1(x~,m) = -0.5*B0(x,m)

C Det=kDk*pDp-pDk^2
  pDk=0.5*qDq-0.5*kDk-0.5*pDp

Id,qDq=pDp+kDk+2*pDk
Id,Multi,pDk^2=kDk*pDp-Det
*end

C Tests 3.  Identity among dotproducts.

V p1,p2,p3,p4,p5,p6,p7,p8,p9,pA,pB,pC,pE,pF,pG,pH
Z xx = {  p1Dp2*Epf(p3,p4,p5,p6)
	- p1Dp3*Epf(p2,p4,p5,p6)
	- p1Dp4*Epf(p3,p2,p5,p6)
	- p1Dp5*Epf(p3,p4,p2,p6)
	- p1Dp6*Epf(p3,p4,p5,p2) } * Epf(p7,p8,p9,pA)
Id,Gammas
*yep

Id,Numer,p1Dp2,72073513.,p1Dp3,84624678.,p1Dp4,52509276.,p1Dp5,51607603.
Al,Numer,p1Dp6,97117707.,p1Dp7,56091995.,p1Dp8,86086713.,p1Dp9,35361640.
Al,Numer,p1DpA,52382708.,p2Dp3,99738370.,p2Dp4,86314985.,p2Dp5,70453871.
Al,Numer,p2Dp6,114248683.,p2Dp7,71422567.,p2Dp8,111259313.,p2Dp9,53967084.
Al,Numer,p2DpA,67563860.,p3Dp4,81886836.,p3Dp5,78333162.,p3Dp6,129931642.
Al,Numer,p3Dp7,73417210.,p3Dp8,114641070.,p3Dp9,53105168.,p3DpA,67662024.
Al,Numer,p4Dp5,65638463.,p4Dp6,95841513.,p4Dp7,57807475.,p4Dp8,91573602.
Al,Numer,p4Dp9,48779546.,p4DpA,53427202.,p5Dp6,90443091.,p5Dp7,47695075.
Al,Numer,p5Dp8,76742276.,p5Dp9,40483748.,p5DpA,45773000.,p6Dp7,89530891.
Al,Numer,p6Dp8,139462170.,p6Dp9,66035460.,p6DpA,69714280.,p7Dp8,83332720.
Id,Numer,p7Dp9,38621796.,p7DpA,45376392.,p8Dp9,60708938.,p8DpA,70447618.
Al,Numer,p9DpA,31692264.
*end

C Tests 4. Simple freeze example.

Common AA1,AA2
Z AA1=x1*(ax1+ay1)+x2*(bx1+by2)
Z AA2=y1*(ax1+ay1)+y2*(bx1+by2)
B x1,x2,y1,y2
*begin
Freeze AA1,AA2
P output
*begin
Z AA1=AA1
Z AA2=AA2
P output
P lists
*yep
Id,Expand,AA1
Id,Expand,AA2
*end

C Tests 5.  Freeze example involving many (261) subfiles.

P lists
P stats
A x
*fix
B x,xx
Common xfile,yfile
Z xfile=DS(J1,-4,126,(x^J1*y^J1))
 + DS(J2,-4,126,(xx^J2*y^J2))
P noutput
*begin
Z yfile=xfile
*begin
Freeze xfile
Z xx2=xfile - yfile
Id,Expand,xfile
*end

C Tests 6. Reproduces the last equation in Gammatrica.

I m1=N,m2=N,m3=N,m4=N,m5=N,m6=N,m7=N,m8=N,m9=N,mA=N
A M

Z xx =
 G(1,"t,"4,m1,m2,m3,m4,m5,m6,m7,m8,m9,mA,m1,m2,m3,m4,m5,m6,m7,m8,m9,mA)

Id,Gammas
P stats
*yep
Id,N_=N-4
Id,N=M
*yep
Id,M=N_
*yep
Id,Addfa,(1/N_/4)
Id,N_=N-4
*end

C Tests 7.  Lehmann parameters.

F ln
B s
Z AVY(s,t,u) = - 1/36*s*t - 1/36*t^2 + 5/144*s^2 + 9/32*s^2*B0
 + 1/32*gu^2*s^2*B0
 - 1/32*s^2*(1+gup^2)*(ln(s) - ln(m2))
 - (1/96*s*t + 1/48*t^2)*(ln(t)-ln(m2))
 - (1/96*s*u + 1/48*u^2)*(ln(u)-ln(m2))

Z AL(s,t,u) = C*{3*s^2*(ln(s) - a1 - ln(m2))
 + t*(t-u)*(ln(t) - a2 - ln(m2))
 + u*(u-t)*(ln(u) - a2 - ln(m2))}

C Relation between a1, a2 and Lehman's alfa1, alfa2:
 ax = - ln(alfax*m^2)
 Note that this makes ln(s) - a1 - ln(m^2) = ln(alfa1*s).
 The coefficients beta1 and beta2 are defined by:
 betax = - ln(alfax*Cp), with Cp = 16*Pi^2*Fpi^2 and Fpi = 92 MeV,
 as deduced from PCAC.
 The critical quantity is
 x = 1/2*(beta2-beta1-1/9) = 1/2*(a2-a1-1/9)
 Note that the quantity Cp is irrelevant here.

Keep AVY,AL

Id,u=-s-t

*next

Z diff= AVY(s,t,u) - AL(s,t,u)

Z x = 1/2*(a2-a1-1/9)

Id,u=-s-t
Al,C=-1/96
Al,a1=32*( 5/144 + 9/32*B0 + 1/32*B0*gu^2 + 1/144 )
Al,a2=-24/36

Keep AVY,AL,x

*next
Z I0d = 3*AL(s,t,u) + AL(u,s,t) + AL(t,u,s)
Z I1d = AL(u,s,t) - AL(t,u,s)
Z I2d = AL(u,s,t) + AL(t,u,s)

Id,u=-s-t
Al,C=-1/96

Keep x
*next

Z x=x

Id,B0 = Pi/sqrt3 - 2

P output
*yep

N R0
Id,Numer,Pi,3.141592654,sqrt3,1.732050808

*end

C Tests 8.  Milgram's use of numerics for function args.

Z test=MAXS(-1,0,-1)
Id,MAXS(MA0~,MA1~,MA2~)=
 MXFS(
  	(  MA0*DT(MA0-MA1,MA0-MA2)
   	+ MA1*DT(MA1-MA0,MA1-MA2)
   	+ MA2*DT(MA2-MA0,MA2-MA1)
   	- MA0*DK(MA0,MA1)*DT(MA0-MA2)
   	- MA1*DK(MA1,MA2)*DT(MA1-MA0)
   	- MA2*DK(MA2,MA0)*DT(MA2-MA1)
   	+ MA0*DT(MA0-MA1,MA1-MA2,MA2-MA0)
	)
 	*DT( MA0*DT(MA0-MA1,MA0-MA2)
    		+ MA1*DT(MA1-MA0,MA1-MA2)
    		+ MA2*DT(MA2-MA0,MA2-MA1)
    		- MA0*DK(MA0,MA1)*DT(MA0-MA2)
    		- MA1*DK(MA1,MA2)*DT(MA1-MA0)
    		- MA2*DK(MA2,MA0)*DT(MA2-MA1)
    		+ MA0*DT(MA0-MA1,MA1-MA2,MA2-MA0)
		)
 	- DT( -1-	(
		MA0*DT(MA0-MA1,MA0-MA2)+MA1*DT(MA1-MA0,MA1-MA2)
         	+MA2*DT(MA2-MA0,MA2-MA1)
         	-MA0*DK(MA0,MA1)*DT(MA0-MA2)
         	-MA1*DK(MA1,MA2)*DT(MA1-MA0)
         	-MA2*DK(MA2,MA0)*DT(MA2-MA1)
         	+MA0*DT(MA0-MA1,MA1-MA2,MA2-MA0)
			 )
		)
    )
*end

C Tests 9.  Milgram's use of numerics for function args. Alternative.

Z test=MAXS(-1,0,-1)
Id,MAXS(MA0~,MA1~,MA2~)=MXFS1(MA0,MA1,MA2,MA1-MA0,MA2-MA0,MA2-MA1)
Id,MXFS1(MA0~,MA1~,MA2~,MA10~,MA20~,MA21~)
 = MXFS2(  MA0*DT(-MA10,-MA20)
   	+ MA1*DT(MA10,-MA21)
   	+ MA2*DT(MA20,MA21)
   	- MA0*DK(MA0,MA1)*DT(-MA20)
   	- MA1*DK(MA1,MA2)*DT(MA10)
   	- MA2*DK(MA2,MA0)*DT(MA21)
   	+ MA0*DT(-MA10,-MA21,MA20)
	,
	 MA0*DT(-MA10,-MA20)
    	+ MA1*DT(MA10,-MA21)
    	+ MA2*DT(MA20,MA21)
    	- MA0*DK(MA0,MA1)*DT(-MA20)
    	- MA1*DK(MA1,MA2)*DT(MA10)
    	- MA2*DK(MA2,MA0)*DT(MA21)
    	+ MA0*DT(-MA10,-MA21,MA20)
	,
	 -1-	(
		MA0*DT(-MA10,-MA20)+MA1*DT(MA10,-MA21)
         	+MA2*DT(MA20,MA21)
         	-MA0*DK(MA0,MA1)*DT(-MA20)
         	-MA1*DK(MA1,MA2)*DT(MA10)
         	-MA2*DK(MA2,MA0)*DT(MA21)
         	+MA0*DT(-MA10,-MA21,MA20)) )

Id,MXFS2(CX1~,CX2~,CX3~) = MXFS(CX1*DT(CX2)-DT(CX3))
*end

C Tests 10. Spin 3/2.

I Mu,Mup,i1,i2,al,be
A m
V p
F Dia=u
Z xx=Dia(Mu,i1,1)
Id,Dia(Mu~,i1~,n~)=Ug(i1,be,m,p)*Ubg(i2,al,m,p)

   -{ D(be,al)*Gi(i1,2) - 1/3*i*G(i1,2,be)*p(al)/m
     + 1/3*i*G(i1,2,al)*p(be)/m
     - 1/3*G(i1,2,be,al) + 2/3*Gi(i1,2)*p(be)*p(al)/m^2 }
	* { - i*G(2,i2,p) + m*Gi(2,i2) }

P output
*yep
P output
Id,Spin,i1,i2,1,2
*yep
Id,Gammas
*end

C Tests 11. Test of Count command with "F option.

F Fx,Fy
A a1,a2,a3
V p,q
Z aa = p(mu)*Fx(a1,a2,a3,p,q,p)
Id,Count,Fy,"F,Fx,a1,10 :"F,Fx,p,1 :"F,Fx,q,7

C Result must be:
  aa = + Fy(10,3,7)*Fx(a1,a2,a3,p,q,p)*p(mu) + 0.

*end

C Tests 12. Traces with mixed 4 and N-dim quantities.

I mu,nu,al=N,be=N,ga=N,de=N

Z ft1 = G(1,1,mu,G5,al,be,nu,G5,be,al) 
Z ft2 = G(1,1,mu,G5,nu,G5) 
Z ft3 = G(1,1,mu,G5,al,be,nu,G5,al,be) 
Z ft1p = G(2,2,mu,G5,al,be,nu,G5,be,al) 
Z ft2p = G(2,2,mu,G5,nu,G5) 
Z ft3p = G(2,2,mu,G5,al,be,nu,G5,al,be) 

Id,Gammas,1:"A,2

C The "A applies to index 1.
  Answer expected:
 ft1 = + D(mu,nu) * ( - 16 - 16*N_ - 4*N_^2 )
 ft2 = - 4*D(mu,nu)
 ft3 = + D(mu,nu) * ( - 16 + 8*N_ + 4*N_^2 )
 ft1p = + D(mu,nu) * ( - 16 + 16*N_ - 4*N_^2 )
 ft2p = - 4*D(mu,nu)
 ft3p = + D(mu,nu) * ( - 16 - 24*N_ + 4*N_^2 )
*end
